/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.encrypt.pki;

import com.yeepay.g3.utils.common.encrypt.Base64;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import javax.crypto.Cipher;

public class RSA {
    public static boolean verifySign(byte[] data, byte[] sign, PublicKey publicKey) {
        try {
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(publicKey);
            signature.update(data);
            boolean result = signature.verify(sign);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("verifySign fail!", e);
        }
    }

    public static boolean verifySign(String data, String sign, PublicKey pubicKey) {
        try {
            byte[] dataByte = data.getBytes("UTF-8");
            byte[] signByte = Base64.decode(sign.getBytes("UTF-8"));
            return RSA.verifySign(dataByte, signByte, pubicKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("verifySign fail!", e);
        }
    }

    public static byte[] sign(byte[] data, PrivateKey key) {
        try {
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initSign(key);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            throw new RuntimeException("sign fail!", e);
        }
    }

    public static String sign(String data, PrivateKey key) {
        try {
            byte[] dataByte = data.getBytes("UTF-8");
            return new String(Base64.encode(RSA.sign(dataByte, key)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("sign fail!", e);
        }
    }

    public static byte[] encrypt(byte[] data, Key key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("encrypt fail!", e);
        }
    }

    public static String encryptToBase64(String data, Key key) {
        try {
            return new String(Base64.encode(RSA.encrypt(data.getBytes("UTF-8"), key)));
        }
        catch (Exception e) {
            throw new RuntimeException("encrypt fail!", e);
        }
    }

    public static byte[] decrypt(byte[] data, Key key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("encrypt fail!", e);
        }
    }

    public static String decryptFromBase64(String data, Key key) {
        try {
            return new String(RSA.decrypt(Base64.decode(data.getBytes()), key), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("encrypt fail!", e);
        }
    }
}

