/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.exception;

import com.yeepay.g3.utils.common.ArrayUtils;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.UUID;

public class YeepayBizException
extends RuntimeException {
    private static final long serialVersionUID = -5097768787801034398L;
    protected String id;
    protected String message;
    protected String defineCode;
    protected String realClassName;

    protected YeepayBizException(String defineCode) {
        this.defineCode = defineCode;
        this.initId();
    }

    private void initId() {
        this.id = UUID.randomUUID().toString().toUpperCase().replaceAll("-", "");
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message, Object ... args) {
        this.message = MessageFormat.format(message, args);
    }

    public String getDefineCode() {
        return this.defineCode;
    }

    public static <T extends YeepayBizException> T newException(T exception, String message, Object ... args) {
        if (exception == null) {
            throw new RuntimeException("no exception instance specified");
        }
        try {
            Constructor<?> constructor = exception.getClass().getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            YeepayBizException newException = (YeepayBizException)constructor.newInstance(exception.getDefineCode());
            newException.setMessage(message, args);
            return (T)newException;
        }
        catch (Throwable e) {
            throw new RuntimeException("create exception instance fail : " + e.getMessage(), e);
        }
    }

    public boolean codeEquals(YeepayBizException e) {
        if (e == null) {
            return false;
        }
        if (!e.getClass().equals(this.getClass())) {
            return false;
        }
        return e.getDefineCode().equals(this.getDefineCode());
    }

    public YeepayBizException upcasting() {
        if (this.getClass().equals(YeepayBizException.class)) {
            return this;
        }
        YeepayBizException superexception = new YeepayBizException(this.defineCode);
        superexception.message = this.message;
        superexception.realClassName = this.getClass().getName();
        superexception.id = this.id;
        superexception.setStackTrace(this.getStackTrace());
        return superexception;
    }

    public YeepayBizException downcasting() {
        if (this.realClassName == null || YeepayBizException.class.getName().equals(this.realClassName)) {
            return this;
        }
        Class<?> clz = null;
        try {
            clz = Class.forName(this.realClassName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (clz == null) {
            return this;
        }
        try {
            Constructor<?> constructor = clz.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            YeepayBizException newException = (YeepayBizException)constructor.newInstance(this.defineCode);
            newException.message = this.message;
            newException.id = this.id;
            newException.setStackTrace(this.getStackTrace());
            return newException;
        }
        catch (Throwable e) {
            return this;
        }
    }

    public String getRealClassName() {
        if (this.realClassName == null) {
            return this.getClass().getName();
        }
        return this.realClassName;
    }

    public void mergeStackTrace(StackTraceElement[] stackTrace) {
        this.setStackTrace(ArrayUtils.addAll(this.getStackTrace(), stackTrace));
    }

    public StackTraceElement[] getCoreStackTrace() {
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        for (StackTraceElement traceEle : this.getStackTrace()) {
            if (!traceEle.getClassName().startsWith("com.yeepay")) continue;
            list.add(traceEle);
        }
        StackTraceElement[] stackTrace = new StackTraceElement[list.size()];
        return list.toArray(stackTrace);
    }

    public String getCoreStackTraceStr() {
        StringBuffer sb = new StringBuffer();
        for (StackTraceElement traceEle : this.getCoreStackTrace()) {
            sb.append("\n" + traceEle.toString());
        }
        return sb.toString();
    }
}

