/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.exception;

import com.yeepay.g3.utils.common.ArrayUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.UUID;

public class YeepayRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 2381136802566762335L;
    private String id;
    private String message;
    protected String realClassName;

    public YeepayRuntimeException() {
        this.initId();
    }

    public YeepayRuntimeException(String message, Object ... args) {
        this.setMessageFormat(message, args);
        this.initId();
    }

    public YeepayRuntimeException(Throwable throwable) {
        this.setMessage(throwable.getMessage());
        this.setStackTrace(throwable.getStackTrace());
        this.realClassName = throwable.getClass().getName();
        this.initId();
    }

    public YeepayRuntimeException(String message, Throwable throwable, Object ... args) {
        this.setMessageFormat(message, args);
        this.setStackTrace(throwable.getStackTrace());
        this.realClassName = throwable.getClass().getName();
        this.initId();
    }

    private void initId() {
        this.id = UUID.randomUUID().toString().toUpperCase().replaceAll("-", "");
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    private void setMessage(String message) {
        this.message = message;
    }

    private void setMessageFormat(String message, Object ... args) {
        if (message != null && args != null) {
            this.setMessage(MessageFormat.format(message, args));
        } else {
            this.setMessage(message);
        }
    }

    public String getRealClassName() {
        if (this.realClassName == null) {
            return this.getClass().getName();
        }
        return this.realClassName;
    }

    public void setRealClassName(String realClassName) {
        this.realClassName = realClassName;
    }

    public void mergeStackTrace(StackTraceElement[] stackTrace) {
        this.setStackTrace(ArrayUtils.addAll(this.getStackTrace(), stackTrace));
    }

    public StackTraceElement[] getCoreStackTrace() {
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        for (StackTraceElement traceEle : this.getStackTrace()) {
            if (!traceEle.getClassName().startsWith("com.yeepay")) continue;
            list.add(traceEle);
        }
        StackTraceElement[] stackTrace = new StackTraceElement[list.size()];
        return list.toArray(stackTrace);
    }

    public String getCoreStackTraceStr() {
        StringBuffer sb = new StringBuffer();
        for (StackTraceElement traceEle : this.getCoreStackTrace()) {
            sb.append("\n" + traceEle.toString());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        YeepayRuntimeException y = new YeepayRuntimeException();
        y.mergeStackTrace(Thread.currentThread().getStackTrace());
        throw y;
    }
}

