/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.httpclient;

import java.util.List;
import java.util.Map;

public class SimpleHttpResult {
    private int statusCode;
    private String content;
    private String exceptionMsg;
    private Exception exception;
    private Map<String, List<String>> headers;
    private String contentType;

    public SimpleHttpResult(int code) {
        this.statusCode = code;
    }

    public SimpleHttpResult(int code, String _content) {
        this.statusCode = code;
        this.content = _content;
    }

    public SimpleHttpResult(Exception e) {
        if (e == null) {
            throw new IllegalArgumentException("exception must be specified");
        }
        this.statusCode = -1;
        this.exception = e;
        this.exceptionMsg = e.getMessage();
    }

    public String getHeaderField(String key) {
        if (this.headers == null) {
            return null;
        }
        List<String> headerValues = this.headers.get(key);
        if (headerValues == null || headerValues.isEmpty()) {
            return null;
        }
        return headerValues.get(headerValues.size() - 1);
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getExceptionMsg() {
        return this.exceptionMsg;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isSuccess() {
        return this.statusCode == 200;
    }

    public boolean isError() {
        return this.exception != null;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

