/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.httpclient;

import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.HttpsURLConnection;
import com.yeepay.g3.utils.common.CheckUtils;
import com.yeepay.g3.utils.common.httpclient.ClientKeyStore;
import com.yeepay.g3.utils.common.httpclient.SimpleHttpParam;
import com.yeepay.g3.utils.common.httpclient.SimpleHttpResult;
import com.yeepay.g3.utils.common.httpclient.TrustKeyStore;
import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SimpleHttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(SimpleHttpUtils.class);
    public static final String DEFAULT_CHARSET = "utf-8";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_ERROR_MESSAGE = "http_error_message";
    public static final int DEFAULT_READ_TIMEOUT = 20000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static final String HTTP_PREFIX = "http://";
    public static final String HTTPS_PREFIX = "https://";
    public static final int MAX_FETCHSIZE = 5000;
    private static TrustManager[] trustAnyManagers = new TrustManager[]{new TrustAnyTrustManager()};

    public static String httpPost(String url, Map params) {
        return SimpleHttpUtils.httpRequest(url, params, HTTP_METHOD_POST, DEFAULT_CHARSET, null);
    }

    public static String httpGet(String url, Map params) {
        return SimpleHttpUtils.httpRequest(url, params, HTTP_METHOD_GET, DEFAULT_CHARSET, null);
    }

    public static String httpRequest(String url, Map<String, String> params, String method, String charSet, Map<String, String> headers) {
        SimpleHttpParam param = new SimpleHttpParam(url);
        if (!CheckUtils.isNull(params)) {
            param.setParameters(params);
        }
        if (!CheckUtils.isNull(headers)) {
            param.setHeaders(headers);
        }
        param.setCharSet(charSet);
        param.setMethod(method);
        SimpleHttpResult result = SimpleHttpUtils.httpRequest(param);
        if (result == null || !result.isSuccess()) {
            return null;
        }
        return result.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleHttpResult httpRequest(SimpleHttpParam httpParam) {
        String url = httpParam.getUrl();
        Map parameters = httpParam.getParameters();
        String sMethod = httpParam.getMethod();
        String charSet = httpParam.getCharSet();
        boolean sslVerify = httpParam.isSslVerify();
        int maxResultSize = httpParam.getMaxResultSize();
        Map headers = httpParam.getHeaders();
        int readTimeout = httpParam.getReadTimeout();
        int connectTimeout = httpParam.getConnectTimeout();
        boolean ignoreContentIfUnsuccess = httpParam.isIgnoreContentIfUnsuccess();
        boolean hostnameVerify = httpParam.isHostnameVerify();
        TrustKeyStore trustKeyStore = httpParam.getTrustKeyStore();
        ClientKeyStore clientKeyStore = httpParam.getClientKeyStore();
        if (url == null || url.trim().length() == 0) {
            throw new IllegalArgumentException("invalid url : " + url);
        }
        if (maxResultSize <= 0) {
            throw new IllegalArgumentException("maxResultSize must be positive : " + maxResultSize);
        }
        Charset.forName(charSet);
        HttpURLConnection urlConn = null;
        URL destURL = null;
        String baseUrl = url.trim();
        if (!baseUrl.toLowerCase().startsWith(HTTPS_PREFIX) && !baseUrl.toLowerCase().startsWith(HTTP_PREFIX)) {
            baseUrl = HTTP_PREFIX + baseUrl;
        }
        String method = null;
        if (sMethod != null) {
            method = sMethod.toUpperCase();
        }
        if (method == null || !method.equals(HTTP_METHOD_POST) && !method.equals(HTTP_METHOD_GET)) {
            throw new IllegalArgumentException("invalid http method : " + method);
        }
        int index = baseUrl.indexOf("?");
        if (index > 0) {
            baseUrl = SimpleHttpUtils.urlEncode(baseUrl, charSet);
        } else if (index == 0) {
            throw new IllegalArgumentException("invalid url : " + url);
        }
        String queryString = SimpleHttpUtils.mapToQueryString(parameters, charSet);
        String targetUrl = "";
        targetUrl = method.equals(HTTP_METHOD_POST) ? baseUrl : (index > 0 ? baseUrl + "&" + queryString : baseUrl + "?" + queryString);
        try {
            Object values;
            destURL = new URL(targetUrl);
            urlConn = (HttpURLConnection)destURL.openConnection();
            SimpleHttpUtils.setSSLSocketFactory(urlConn, sslVerify, hostnameVerify, trustKeyStore, clientKeyStore);
            boolean hasContentType = false;
            boolean hasUserAgent = false;
            for (String string : headers.keySet()) {
                if ("Content-Type".equalsIgnoreCase(string)) {
                    hasContentType = true;
                }
                if (!"user-agent".equalsIgnoreCase(string)) continue;
                hasUserAgent = true;
            }
            if (!hasContentType) {
                headers.put("Content-Type", "application/x-www-form-urlencoded; charset=" + charSet);
            }
            if (!hasUserAgent) {
                headers.put("user-agent", "YeepaySystem");
            }
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry entry : headers.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    values = SimpleHttpUtils.makeStringList(value);
                    Iterator<String> i$ = values.iterator();
                    while (i$.hasNext()) {
                        String v = i$.next();
                        urlConn.addRequestProperty(key, v);
                    }
                }
            }
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setAllowUserInteraction(false);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod(method);
            urlConn.setConnectTimeout(connectTimeout);
            urlConn.setReadTimeout(readTimeout);
            if (method.equals(HTTP_METHOD_POST)) {
                String postData;
                String string = postData = queryString.length() == 0 ? httpParam.getPostData() : queryString;
                if (postData != null && postData.trim().length() > 0) {
                    OutputStream outputStream = urlConn.getOutputStream();
                    OutputStreamWriter osw = new OutputStreamWriter(outputStream, charSet);
                    osw.write(postData);
                    osw.flush();
                    osw.close();
                }
            }
            int responseCode = urlConn.getResponseCode();
            Map<String, List<String>> map = urlConn.getHeaderFields();
            String contentType = urlConn.getContentType();
            SimpleHttpResult result = new SimpleHttpResult(responseCode);
            result.setHeaders(map);
            result.setContentType(contentType);
            if (responseCode != 200 && ignoreContentIfUnsuccess) {
                values = result;
                return values;
            }
            InputStream is = urlConn.getInputStream();
            byte[] temp = new byte[1024];
            ByteBuffer buffer = ByteBuffer.allocate(maxResultSize);
            int readBytes = is.read(temp);
            while (readBytes > 0) {
                if (buffer.remaining() < readBytes) {
                    buffer.put(temp, 0, buffer.remaining());
                    break;
                }
                buffer.put(temp, 0, readBytes);
                readBytes = is.read(temp);
            }
            String resultString = new String(buffer.array(), charSet).trim();
            result.setContent(resultString);
            SimpleHttpResult simpleHttpResult = result;
            return simpleHttpResult;
        }
        catch (Exception e) {
            logger.warn("connection error : " + e.getMessage());
            SimpleHttpResult simpleHttpResult = new SimpleHttpResult(e);
            return simpleHttpResult;
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }

    public static String urlEncode(String url, String charSet) {
        if (url == null || url.trim().length() == 0) {
            return url;
        }
        int splitIndex = url.indexOf("?");
        if (splitIndex <= 0) {
            return url;
        }
        String serviceUrl = url.substring(0, splitIndex);
        String queryString = url.substring(splitIndex + 1, url.length());
        String newQueryString = "";
        if (queryString.length() > 0) {
            String[] nameValues;
            for (String nameValue : nameValues = queryString.split("&")) {
                int index = nameValue.indexOf("=");
                String pname = null;
                String pvalue = null;
                if (index < 0) {
                    pname = nameValue;
                    pvalue = "";
                } else {
                    pname = nameValue.substring(0, index);
                    pvalue = nameValue.substring(index + 1, nameValue.length());
                    try {
                        pvalue = URLEncoder.encode(pvalue, charSet);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalArgumentException("invalid charset : " + charSet);
                    }
                }
                newQueryString = newQueryString + pname + "=" + pvalue + "&";
            }
            newQueryString = newQueryString.substring(0, newQueryString.length() - 1);
        }
        return serviceUrl + "?" + newQueryString;
    }

    public static String mapToQueryString(Map parameters, String charSet) {
        String queryString = "";
        if (parameters != null && !parameters.isEmpty()) {
            Set entrySet = parameters.entrySet();
            for (Map.Entry entry : entrySet) {
                try {
                    String key = entry.getKey().toString();
                    Object value = entry.getValue();
                    List<String> values = SimpleHttpUtils.makeStringList(value);
                    for (String v : values) {
                        queryString = queryString + key + "=" + URLEncoder.encode(v == null ? "" : v.toString(), charSet) + "&";
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("invalid charset : " + charSet);
                }
            }
            if (queryString.length() > 0) {
                queryString = queryString.substring(0, queryString.length() - 1);
            }
        }
        return queryString;
    }

    public static Map queryStringToMap(String queryString, String charSet) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString must be specified");
        }
        int index = queryString.indexOf("?");
        if (index > 0) {
            queryString = queryString.substring(index + 1);
        }
        String[] keyValuePairs = queryString.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String keyValue : keyValuePairs) {
            if (keyValue.indexOf("=") == -1) continue;
            String[] args = keyValue.split("=");
            if (args.length == 2) {
                try {
                    map.put(args[0], URLDecoder.decode(args[1], charSet));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("invalid charset : " + charSet);
                }
            }
            if (args.length != 1) continue;
            map.put(args[0], "");
        }
        return map;
    }

    private static void setSSLSocketFactory(HttpURLConnection urlConn, boolean sslVerify, boolean hostnameVerify, TrustKeyStore trustCertFactory, ClientKeyStore clientKeyFactory) {
        try {
            javax.net.ssl.HttpsURLConnection httpsUrlCon;
            SSLSocketFactory socketFactory = null;
            if (trustCertFactory != null || clientKeyFactory != null || !sslVerify) {
                SSLContext sc = SSLContext.getInstance("SSL");
                TrustManager[] trustManagers = null;
                KeyManager[] keyManagers = null;
                if (trustCertFactory != null) {
                    trustManagers = trustCertFactory.getTrustManagerFactory().getTrustManagers();
                }
                if (clientKeyFactory != null) {
                    keyManagers = clientKeyFactory.getKeyManagerFactory().getKeyManagers();
                }
                if (!sslVerify) {
                    trustManagers = trustAnyManagers;
                    hostnameVerify = false;
                }
                sc.init(keyManagers, trustManagers, new SecureRandom());
                socketFactory = sc.getSocketFactory();
            }
            if (urlConn instanceof javax.net.ssl.HttpsURLConnection) {
                httpsUrlCon = (javax.net.ssl.HttpsURLConnection)urlConn;
                if (socketFactory != null) {
                    httpsUrlCon.setSSLSocketFactory(socketFactory);
                }
                if (!hostnameVerify) {
                    httpsUrlCon.setHostnameVerifier(new TrustAnyHostnameVerifier());
                }
            }
            if (urlConn instanceof HttpsURLConnection) {
                httpsUrlCon = (HttpsURLConnection)urlConn;
                if (socketFactory != null) {
                    httpsUrlCon.setSSLSocketFactory(socketFactory);
                }
                if (!hostnameVerify) {
                    httpsUrlCon.setHostnameVerifier(new TrustAnyHostnameVerifierOld());
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    private static List<String> makeStringList(Object value) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> result = new ArrayList<String>();
        if (value.getClass().isArray()) {
            for (int j = 0; j < Array.getLength(value); ++j) {
                Object obj = Array.get(value, j);
                result.add(obj != null ? obj.toString() : "");
            }
            return result;
        }
        if (value instanceof Iterator) {
            Iterator it = (Iterator)value;
            while (it.hasNext()) {
                Object obj = it.next();
                result.add(obj != null ? obj.toString() : "");
            }
            return result;
        }
        if (value instanceof Collection) {
            for (Object obj : (Collection)value) {
                result.add(obj != null ? obj.toString() : "");
            }
            return result;
        }
        if (value instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)value;
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                result.add(obj != null ? obj.toString() : "");
            }
            return result;
        }
        result.add(value.toString());
        return result;
    }

    public static ClientKeyStore loadClientKeyStore(String keyStorePath, String keyStorePass, String privateKeyPass) {
        try {
            return SimpleHttpUtils.loadClientKeyStore(new FileInputStream(keyStorePath), keyStorePass, privateKeyPass);
        }
        catch (Exception e) {
            logger.error("loadClientKeyFactory fail : " + e.getMessage(), e);
            return null;
        }
    }

    public static ClientKeyStore loadClientKeyStore(InputStream keyStoreStream, String keyStorePass, String privateKeyPass) {
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(keyStoreStream, keyStorePass.toCharArray());
            kmf.init(ks, privateKeyPass.toCharArray());
            return new ClientKeyStore(kmf);
        }
        catch (Exception e) {
            logger.error("loadClientKeyFactory fail : " + e.getMessage(), e);
            return null;
        }
    }

    public static TrustKeyStore loadTrustKeyStore(String keyStorePath, String keyStorePass) {
        try {
            return SimpleHttpUtils.loadTrustKeyStore(new FileInputStream(keyStorePath), keyStorePass);
        }
        catch (Exception e) {
            logger.error("loadTrustCertFactory fail : " + e.getMessage(), e);
            return null;
        }
    }

    public static TrustKeyStore loadTrustKeyStore(InputStream keyStoreStream, String keyStorePass) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(keyStoreStream, keyStorePass.toCharArray());
            tmf.init(ks);
            return new TrustKeyStore(tmf);
        }
        catch (Exception e) {
            logger.error("loadTrustCertFactory fail : " + e.getMessage(), e);
            return null;
        }
    }

    public static void main(String[] args) throws InterruptedException {
        String str = "http://www.scpta.gov.cn/UserPay/BCallback.asp?p1_MerId=10000216814&r0_Cmd=Buy&r1_Code=1&r2_TrxId=418126905762402E&r3_Amt=100.0&r4_Cur=RMB&r5_Pid=2041&r6_Order=BM2041O243605O2184995OZ&r8_MP=&r9_BType=2&ra_Details=&rb_SplitStatus=SPLITED&rc_SourceFee=&rd_TargetFee=&rq_SourceFee=0.0&rq_TargetFee=0.0&rb_BankId=CEB-NET&ro_BankOrderId=2014595416120928&rp_PayDate=20120928172639&peo_checkInDate=&peo_checkOutDate=&hmac=85b92bb7dc10d9d52189008fe1918f45";
        for (int i = 0; i < 10; ++i) {
            String result = SimpleHttpUtils.httpPost(str, null);
            System.out.println(result);
            Thread.currentThread();
            Thread.sleep(1000L);
        }
    }

    public int test() throws InterruptedException {
        String str = "http://www.scpta.gov.cn/UserPay/BCallback.asp?p1_MerId=10000216814&r0_Cmd=Buy&r1_Code=1&r2_TrxId=418126905762402E&r3_Amt=100.0&r4_Cur=RMB&r5_Pid=2041&r6_Order=BM2041O243605O2184995OZ&r8_MP=&r9_BType=2&ra_Details=&rb_SplitStatus=SPLITED&rc_SourceFee=&rd_TargetFee=&rq_SourceFee=0.0&rq_TargetFee=0.0&rb_BankId=CEB-NET&ro_BankOrderId=2014595416120928&rp_PayDate=20120928172639&peo_checkInDate=&peo_checkOutDate=&hmac=85b92bb7dc10d9d52189008fe1918f45";
        for (int i = 0; i < 10; ++i) {
            String result = SimpleHttpUtils.httpPost(str, null);
            System.out.println(result);
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        return 0;
    }

    static {
        System.setProperty("sun.net.inetaddr.ttl", "3600");
    }

    private static class TrustAnyHostnameVerifierOld
    implements HostnameVerifier {
        private TrustAnyHostnameVerifierOld() {
        }

        public boolean verify(String arg0, String arg1) {
            return true;
        }
    }

    private static class TrustAnyHostnameVerifier
    implements javax.net.ssl.HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

