/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.log;

import com.yeepay.g3.utils.common.ReflectionUtils;
import com.yeepay.g3.utils.common.StringUtils;
import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import com.yeepay.g3.utils.common.log.annotation.LogTable;
import com.yeepay.g3.utils.common.log.impl.LogContentBuilder;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DbLogUtils {
    private static final Logger logger = LoggerFactory.getLogger(DbLogUtils.class);
    private static Object logSender;

    public static void save(Object tableObj) {
        DbLogUtils.save(DbLogUtils.class.getName(), tableObj);
    }

    public static void save(String bizMessage) {
        DbLogUtils.save(DbLogUtils.class.getName(), bizMessage);
    }

    public static void save(String loggerName, Object tableObj) {
        String tableName;
        if (tableObj == null) {
            return;
        }
        DbLogUtils.checkInited();
        if (logSender == null) {
            logger.info("logSender is not inited. bizLog(LogTable) : " + ToStringBuilder.reflectionToString((Object)tableObj, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
            return;
        }
        if (tableObj instanceof List) {
            List list = (List)tableObj;
            boolean singleTable = false;
            for (Object obj : list) {
                if (!StringUtils.isNotBlank((String)DbLogUtils.checkLogTable(obj))) continue;
                singleTable = true;
                break;
            }
            if (singleTable) {
                for (Object obj : list) {
                    if (obj instanceof String) {
                        DbLogUtils.save(loggerName, (String)tableObj);
                        continue;
                    }
                    DbLogUtils.save(loggerName, obj);
                }
                return;
            }
        }
        if (StringUtils.isNotBlank((String)(tableName = DbLogUtils.checkLogTable(tableObj)))) {
            try {
                Map<String, Object> columns = LogContentBuilder.build(tableObj);
                ReflectionUtils.executeMethod(logSender, "save", new Object[]{loggerName, tableName, columns}, new Class[]{String.class, String.class, Map.class});
            }
            catch (Throwable t) {
                logger.info("save log error. errMsg : " + t.getMessage() + " bizLog(LogTable) : " + ToStringBuilder.reflectionToString((Object)tableObj, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
            }
        } else {
            DbLogUtils.save(loggerName, ToStringBuilder.reflectionToString((Object)tableObj, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE).replace("\n", " ").replace("\t", "  "));
        }
    }

    public static void save(String loggerName, String bizMessage) {
        if (StringUtils.isBlank((String)bizMessage)) {
            return;
        }
        DbLogUtils.checkInited();
        if (logSender == null) {
            logger.info("logSender is not inited. bizLog : " + bizMessage);
            return;
        }
        try {
            ReflectionUtils.executeMethod(logSender, "save", new Object[]{loggerName, bizMessage}, new Class[]{String.class, String.class});
        }
        catch (Throwable t) {
            logger.info("save log error. errMsg : " + t.getMessage() + " bizLog :" + bizMessage);
        }
    }

    private static String checkLogTable(Object message) {
        if (message == null) {
            return null;
        }
        Class<?> clazz = message.getClass();
        LogTable annotation = clazz.getAnnotation(LogTable.class);
        if (annotation != null) {
            return annotation.tableName().toUpperCase();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInited() {
        if (logSender != null) {
            return;
        }
        try {
            Class<DbLogUtils> clazz = DbLogUtils.class;
            synchronized (DbLogUtils.class) {
                if (logSender == null) {
                    Class<?> cl = Class.forName("com.yeepay.g3.utils.soa.log.BizLoggerExecutor");
                    Method m = cl.getDeclaredMethod("getInstance", new Class[0]);
                    logSender = m.invoke(null, new Object[0]);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        }
        catch (Throwable t) {
            logger.error("init logSender error " + t.getClass().getName(), t);
        }
        {
            return;
        }
    }
}

