/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.log;

import com.yeepay.g3.utils.common.ThreadContextUtils;
import com.yeepay.g3.utils.common.threadcontext.ThreadContextType;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class ThreadContextPatternParser
extends PatternParser {
    public ThreadContextPatternParser(String pattern) {
        super(pattern);
    }

    protected void finalizeConverter(char c) {
        if (c == 'm') {
            this.addConverter(new MessagePatternConverter(this.formattingInfo));
        } else {
            super.finalizeConverter(c);
        }
    }

    private static class MessagePatternConverter
    extends PatternConverter {
        public MessagePatternConverter(FormattingInfo fi) {
            super(fi);
        }

        protected String convert(LoggingEvent event) {
            StringBuilder builder = new StringBuilder();
            if (!ThreadContextUtils.contextInitialized()) {
                ThreadContextUtils.initContext(null, null, ThreadContextType.MANUAL);
            }
            builder.append("APP[");
            builder.append(ThreadContextUtils.getContext().getAppName());
            builder.append("] - TYPE[");
            builder.append((Object)ThreadContextUtils.getContext().getType());
            builder.append("] - GUID[");
            builder.append(ThreadContextUtils.getContext().getThreadUID());
            builder.append("] - LEVEL[");
            builder.append(ThreadContextUtils.getContext().upTransferLevel());
            builder.append("] ");
            builder.append(event.getRenderedMessage());
            return builder.toString();
        }
    }
}

