/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.log.impl;

import com.yeepay.g3.utils.common.DateUtils;
import com.yeepay.g3.utils.common.StringUtils;
import com.yeepay.g3.utils.common.log.annotation.LogColumn;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class LogContentBuilder {
    private static final String COLUMN_NAME_SEPARATOR = "_";
    private static final String[] SKIP_FIELDS = new String[]{"serialVersionUID"};

    public static Map<String, Object> build(Object message) {
        LinkedHashMap<String, Object> columns = new LinkedHashMap<String, Object>();
        Class<?> clazz = message.getClass();
        boolean hasColumnAnnotation = LogContentBuilder.hasColumnAnnotation(clazz);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (LogContentBuilder.isSkip(field.getName()).booleanValue()) continue;
            LogColumn column = field.getAnnotation(LogColumn.class);
            if (column != null) {
                LogContentBuilder.doCreateFieldMsg(field, columns, column, message);
                continue;
            }
            if (hasColumnAnnotation) continue;
            String columnName = LogContentBuilder.getColumnName(field.getName());
            LogContentBuilder.doCreateFieldMsg(field, columns, columnName, message);
        }
        return columns;
    }

    private static boolean hasColumnAnnotation(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            LogColumn column = field.getAnnotation(LogColumn.class);
            if (column == null) continue;
            return true;
        }
        return false;
    }

    private static void doCreateFieldMsg(Field field, Map<String, Object> columns, LogColumn column, Object message) {
        try {
            String columnName = column.name().toUpperCase();
            field.setAccessible(true);
            Object value = LogContentBuilder.getFieldValue(field, message);
            if (column.length() > 0 && value instanceof String) {
                String strVal = (String)value;
                if (column.subtype() == LogColumn.SubType.CHAR && strVal.length() > column.length()) {
                    value = strVal.substring(0, column.length());
                } else if (column.subtype() == LogColumn.SubType.BYTE) {
                    value = StringUtils.substringByByte(strVal, 0, column.length());
                }
            }
            columns.put(columnName, value);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    private static void doCreateFieldMsg(Field field, Map<String, Object> columns, String columnName, Object message) {
        try {
            field.setAccessible(true);
            columns.put(columnName, LogContentBuilder.getFieldValue(field, message));
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    private static String getColumnName(String fieldName) {
        StringBuilder columnName = new StringBuilder();
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (Character.isUpperCase(c)) {
                columnName.append(COLUMN_NAME_SEPARATOR);
            }
            columnName.append(c);
        }
        return columnName.toString().toUpperCase();
    }

    private static Object getFieldValue(Field field, Object message) throws IllegalArgumentException, IllegalAccessException, SQLException {
        Class<?> fieldType = field.getType();
        Object fieldValue = field.get(message);
        if (fieldValue == null) {
            return fieldValue;
        }
        if (fieldType.isArray()) {
            return LogContentBuilder.getArrayFieldValue(fieldValue);
        }
        return LogContentBuilder.getNormalFieldValue(fieldType, fieldValue);
    }

    private static String getBlobFieldValue(Object fieldValue) throws NumberFormatException, SQLException {
        Blob blob = (Blob)fieldValue;
        byte[] datas = blob.getBytes(0L, Integer.parseInt(String.valueOf(blob.length())));
        return new String(datas);
    }

    private static String getClobFieldValue(Object fieldValue) throws NumberFormatException, SQLException {
        Clob clob = (Clob)fieldValue;
        return clob.getSubString(0L, Integer.parseInt(String.valueOf(clob.length())));
    }

    private static Object getArrayFieldValue(Object fieldValue) throws NumberFormatException, SQLException {
        String result = null;
        StringBuffer sb = new StringBuffer();
        int length = Array.getLength(fieldValue);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(fieldValue, i);
            Class<?> valueType = value.getClass();
            Object fvalue = LogContentBuilder.getNormalFieldValue(valueType, value);
            sb.append(fvalue);
        }
        result = sb.toString();
        return result;
    }

    private static Object getNormalFieldValue(Class<?> fieldType, Object fieldValue) throws NumberFormatException, SQLException {
        if (fieldValue == null || fieldValue instanceof String) {
            return fieldValue;
        }
        if (fieldValue instanceof Enum) {
            return ((Enum)fieldValue).name();
        }
        if (fieldValue instanceof Blob) {
            return LogContentBuilder.getBlobFieldValue(fieldValue);
        }
        if (fieldValue instanceof Clob) {
            return LogContentBuilder.getClobFieldValue(fieldValue);
        }
        if (fieldValue instanceof Date) {
            return LogContentBuilder.getDateFieldValue(fieldValue);
        }
        if (fieldValue instanceof Timestamp) {
            return LogContentBuilder.getTimestampFieldValue(fieldValue);
        }
        if (fieldValue instanceof Boolean) {
            return LogContentBuilder.getBooleanFieldValue(fieldValue);
        }
        if (fieldType.getName().startsWith("com.yeepay")) {
            return StringUtils.trim(ToStringBuilder.reflectionToString((Object)fieldValue, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE).replace("\n", " ").replace("\t", "  "));
        }
        return fieldValue;
    }

    private static Object getDateFieldValue(Object fieldValue) {
        Date date = (Date)fieldValue;
        return DateUtils.toString(date, DateUtils.DATE_FORMAT_DATETIME);
    }

    private static Object getTimestampFieldValue(Object fieldValue) {
        Timestamp stamp = (Timestamp)fieldValue;
        return DateUtils.toSqlTimestampString(stamp, DateUtils.DATE_FORMAT_DATETIME);
    }

    private static Object getBooleanFieldValue(Object fieldValue) {
        Boolean b = (Boolean)fieldValue;
        return b != false ? 1 : 0;
    }

    private static Boolean isSkip(String fieldName) {
        for (String name : SKIP_FIELDS) {
            if (!name.equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }
}

