/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.log.impl;

import com.yeepay.g3.utils.common.log.DbLogUtils;
import com.yeepay.g3.utils.common.log.LogFormattingTuple;
import com.yeepay.g3.utils.common.log.LogMessageFormatter;
import com.yeepay.g3.utils.common.log.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggerImpl
implements Logger {
    private Log logger;
    private String loggerName;

    public LoggerImpl(String loggerName) {
        this.logger = LogFactory.getLog((String)loggerName);
        this.loggerName = loggerName;
    }

    public LoggerImpl(Class<?> clazz) {
        this.logger = LogFactory.getLog(clazz);
        this.loggerName = clazz.getName();
    }

    @Override
    public void debug(String msg) {
        this.logger.debug((Object)msg);
    }

    @Override
    public void debug(String format, Object ... arg) {
        LogFormattingTuple ft = LogMessageFormatter.format(format, arg);
        this.logger.debug((Object)ft.getMessage());
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logger.debug((Object)msg, t);
    }

    @Override
    public void error(String msg) {
        this.logger.error((Object)msg);
    }

    @Override
    public void error(String format, Object ... arg) {
        LogFormattingTuple ft = LogMessageFormatter.format(format, arg);
        this.logger.error((Object)ft.getMessage());
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logger.error((Object)msg, t);
    }

    @Override
    public void info(String msg) {
        this.logger.info((Object)msg);
    }

    @Override
    public void info(String format, Object ... arg) {
        LogFormattingTuple ft = LogMessageFormatter.format(format, arg);
        this.logger.info((Object)ft.getMessage());
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logger.info((Object)msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void trace(String msg) {
        this.logger.trace((Object)msg);
    }

    @Override
    public void trace(String format, Object ... arg) {
        LogFormattingTuple ft = LogMessageFormatter.format(format, arg);
        this.logger.trace((Object)ft.getMessage());
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logger.trace((Object)msg, t);
    }

    @Override
    public void warn(String msg) {
        this.logger.warn((Object)msg);
    }

    @Override
    public void warn(String format, Object ... arg) {
        LogFormattingTuple ft = LogMessageFormatter.format(format, arg);
        this.logger.warn((Object)ft.getMessage());
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logger.warn((Object)msg, t);
    }

    @Override
    public void saveToDB(Object tableObj) {
        DbLogUtils.save(this.loggerName, tableObj);
    }

    @Override
    public void saveToDB(String bizMessage) {
        DbLogUtils.save(this.loggerName, bizMessage);
    }
}

