/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.monitor;

import com.yeepay.g3.utils.common.DateUtils;
import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import com.yeepay.g3.utils.common.monitor.ListableServiceMonitor;
import com.yeepay.g3.utils.common.monitor.ServiceMonitorRegister;
import com.yeepay.g3.utils.management.core.annotation.ManagedAttribute;
import com.yeepay.g3.utils.management.core.annotation.ManagedBean;
import com.yeepay.g3.utils.management.core.annotation.ManagedOperation;
import com.yeepay.g3.utils.management.core.annotation.Param;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

@ManagedBean(name="com.yeepay.3g.management:type=YeepayAttribute,name=ServiceMonitorListModel")
public class ServiceMonitorListModel
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ServiceMonitorListModel.class);
    private static final long serialVersionUID = -1162653854205071265L;
    private static final int CONNECTION_HOLD_THRESHOLD = 10;
    private static final int FETCH_CONNECTION_TIMEOUT_THRESHOLD = 5;
    private static final int RELEASE_CONNECTION_TIMEOUT_THRESHOLD = 5;

    @ManagedAttribute
    public List<Map<String, Object>> getDataSourceConnectionStatusList() {
        ListableServiceMonitor ms = ServiceMonitorRegister.getListableServiceMonitor("monitor-datasource-summary");
        if (ms != null) {
            return ms.getAllServiceStatus();
        }
        return null;
    }

    @ManagedOperation
    public Map<String, Object> accquireDataSourceConnectionThreadList(@Param(value="dataSource") String dsName) {
        ListableServiceMonitor ms = ServiceMonitorRegister.getListableServiceMonitor("monitor-connection");
        if (ms != null) {
            return (Map)ms.getServiceStatus(dsName);
        }
        return null;
    }

    @ManagedAttribute
    public boolean getConnectionTimeountAlarm() {
        boolean alarm = false;
        ListableServiceMonitor ms = ServiceMonitorRegister.getListableServiceMonitor("monitor-connection");
        if (ms != null) {
            List list = ms.getAllServiceStatus();
            for (Map map : list) {
                int compareValue;
                String createdTimeStr = (String)map.get("created-time");
                Date createdDate = null;
                try {
                    createdDate = DateUtils.parseDate(createdTimeStr, "yyyy-MM-dd HH:mm:ss:S");
                }
                catch (ParseException e) {
                    logger.error(e.getMessage(), e);
                }
                if ((compareValue = DateUtils.compareTime(DateUtils.addSecond(createdDate, 10), new Date(), 13)) >= 0) continue;
                logger.warn("monitor alarm message:{}", map.toString());
                alarm = true;
            }
        }
        return alarm;
    }

    @ManagedAttribute
    public boolean getFetchConnectionTimeoutAlarm() {
        boolean alarm = false;
        ListableServiceMonitor ms = ServiceMonitorRegister.getListableServiceMonitor("monitor-datasource-summary");
        if (ms != null) {
            List list = ms.getAllServiceStatus();
            for (Map map : list) {
                long fetchAlarmCount = (Long)map.get("fetchAlarmCount");
                if (fetchAlarmCount <= 5L) continue;
                logger.warn("monitor alarm message:{}", map.toString());
                alarm = true;
            }
        }
        return alarm;
    }

    @ManagedAttribute
    public boolean getReleaseConnectionTimeoutAlarm() {
        boolean alarm = false;
        ListableServiceMonitor ms = ServiceMonitorRegister.getListableServiceMonitor("monitor-datasource-summary");
        if (ms != null) {
            List list = ms.getAllServiceStatus();
            for (Map map : list) {
                long releaseAlarmCount = (Long)map.get("releaseAlarmCount");
                if (releaseAlarmCount <= 5L) continue;
                logger.warn("monitor alarm message:{}", map.toString());
                alarm = true;
            }
        }
        return alarm;
    }

    @ManagedAttribute
    public List<Map<String, Object>> getQuotaStatusList() {
        ListableServiceMonitor ms = ServiceMonitorRegister.getListableServiceMonitor("quota");
        if (ms != null) {
            return ms.getAllServiceStatus();
        }
        return null;
    }

    @ManagedAttribute
    public List<Map<String, Object>> getQuotaAlarmStatusList() {
        ListableServiceMonitor ms = ServiceMonitorRegister.getListableServiceMonitor("quota-alarm");
        if (ms != null) {
            return ms.getAllServiceStatus();
        }
        return null;
    }

    @ManagedAttribute
    public boolean getQuotaAlarm() {
        boolean alarm = false;
        List<Map<String, Object>> alarmKeyMap = this.getQuotaAlarmStatusList();
        if (alarmKeyMap != null && alarmKeyMap.size() > 0) {
            logger.warn("monitor alarm message:{}", alarmKeyMap.toString());
            alarm = true;
        }
        return alarm;
    }

    @ManagedAttribute
    public List<Map<String, Object>> getTomcatTimeoutedThreadList() {
        ListableServiceMonitor ms = ServiceMonitorRegister.getListableServiceMonitor("tomcat-monitor-valve");
        if (ms != null) {
            return ms.getAllServiceStatus();
        }
        return null;
    }

    @ManagedAttribute
    public List<Map<String, Object>> getTomcatTimeoutedThreadSummaryList() {
        ListableServiceMonitor ms = ServiceMonitorRegister.getListableServiceMonitor("tomcat-monitor-valve-summary");
        if (ms != null) {
            return ms.getAllServiceStatus();
        }
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

