/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.monitor;

import com.yeepay.g3.utils.common.monitor.ListableServiceMonitor;
import com.yeepay.g3.utils.common.monitor.ServiceMonitor;
import com.yeepay.g3.utils.common.monitor.ServiceMonitorListModel;
import com.yeepay.g3.utils.management.core.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceMonitorRegister {
    private static Map<String, ServiceMonitor> servicemonitors = new ConcurrentHashMap<String, ServiceMonitor>();
    private static Map<String, ListableServiceMonitor> listableservicemonitors = new ConcurrentHashMap<String, ListableServiceMonitor>();

    public static void registServiceMonitor(String name, ServiceMonitor monitor) {
        servicemonitors.put(name, monitor);
    }

    public static void registListableServiceMonitor(String name, ListableServiceMonitor monitor) {
        listableservicemonitors.put(name, monitor);
    }

    public static ServiceMonitor getServiceMonitor(String name) {
        return servicemonitors.get(name);
    }

    public static ListableServiceMonitor getListableServiceMonitor(String name) {
        return listableservicemonitors.get(name);
    }

    static {
        ServiceMonitorRegister.registServiceMonitor("service-monitor", new ServiceMonitor(){

            @Override
            public Object getServiceStatus() {
                return new HashMap(servicemonitors);
            }
        });
        ServiceMonitorRegister.registListableServiceMonitor("service-monitor-list", new ListableServiceMonitor(){

            @Override
            public Object getServiceStatus(String serviceName) {
                return null;
            }

            @Override
            public List<?> getAllServiceStatus() {
                ArrayList list = new ArrayList();
                for (Map.Entry entry : listableservicemonitors.entrySet()) {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    item.put("name", entry.getKey());
                    item.put("object", entry.getValue());
                    list.add(item);
                }
                return list;
            }
        });
        ServiceMonitorListModel model = new ServiceMonitorListModel();
        try {
            new Registry((Object)model).register(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

