/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.monitor.models.model;

import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import com.yeepay.g3.utils.management.client.JmxClient;
import com.yeepay.g3.utils.management.client.LocalJmxClient;
import com.yeepay.g3.utils.management.core.annotation.ManagedAttribute;
import com.yeepay.g3.utils.management.core.annotation.ManagedBean;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.lang.builder.ToStringBuilder;

@ManagedBean(name="com.yeepay.3g.management:type=YeepayAttribute,name=ApplicationStatusModel")
public class ApplicationStatusModel
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(ApplicationStatusModel.class);
    private static final long serialVersionUID = -1762653854205071265L;
    private JmxClient client = new LocalJmxClient();
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ManagedAttribute
    public String getPort() {
        String port = null;
        try {
            ObjectName on;
            Set ons = this.client.queryObjectNames(new ObjectName("Catalina:type=Connector,*"));
            Iterator i$ = ons.iterator();
            while (i$.hasNext() && (port = (on = (ObjectName)i$.next()).getKeyProperty("port")) == null) {
            }
            return port;
        }
        catch (Exception e) {
            return "";
        }
    }

    @ManagedAttribute
    public String getAppServerName() {
        try {
            String[] ts;
            Object tomcatDir = this.client.getAttribute(new ObjectName("Catalina:type=Engine"), "baseDir");
            if (tomcatDir != null && tomcatDir.toString().indexOf("/") >= 0 && (ts = tomcatDir.toString().split("/")).length > 1) {
                return ts[ts.length - 1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @ManagedAttribute
    public Map<String, Map<String, String>> getAppStatusMap() {
        HashMap<String, Map<String, String>> appStatusMap = new HashMap<String, Map<String, String>>();
        try {
            Set ons = this.client.queryObjectNames(new ObjectName("Catalina:j2eeType=WebModule,*"));
            if (ons != null && ons.size() > 0) {
                for (ObjectName on : ons) {
                    Object webModule = this.client.getAttribute(on, "encodedPath");
                    if (webModule.toString().startsWith("/.")) continue;
                    HashMap<String, String> statusValues = new HashMap<String, String>();
                    Object startTime = this.client.getAttribute(on, "startTime");
                    statusValues.put("startTime", this.simpleDateFormat.format(new Date(new Long(startTime.toString()))));
                    Object stateName = this.client.getAttribute(on, "stateName");
                    statusValues.put("stateName", stateName.toString());
                    Object sessionTimeout = this.client.getAttribute(on, "sessionTimeout");
                    statusValues.put("sessionTimeout", sessionTimeout.toString());
                    Object startupTime = this.client.getAttribute(on, "startupTime");
                    statusValues.put("startupTime", startupTime.toString());
                    appStatusMap.put(webModule.toString(), statusValues);
                }
                return appStatusMap;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return null;
    }

    @ManagedAttribute
    public boolean getServerStatusAlarm() {
        boolean alarm = false;
        Map<String, Map<String, String>> appStatusMap = this.getAppStatusMap();
        if (appStatusMap == null) {
            logger.warn("monitor alarm message:{}", "app status null!");
            alarm = true;
        } else {
            Iterator<Map.Entry<String, Map<String, String>>> iterator = appStatusMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Map<String, String>> entry = iterator.next();
                Map<String, String> value = entry.getValue();
                String stateName = value.get("stateName");
                if (!"STARTED".equals(stateName)) continue;
                iterator.remove();
            }
            if (!appStatusMap.isEmpty()) {
                logger.warn("monitor alarm message:{}", appStatusMap.toString());
                alarm = true;
            }
        }
        return alarm;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

