/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.monitor.models.model;

import com.yeepay.g3.utils.common.MathUtils;
import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import com.yeepay.g3.utils.management.client.JmxClient;
import com.yeepay.g3.utils.management.client.LocalJmxClient;
import com.yeepay.g3.utils.management.core.annotation.ManagedAttribute;
import com.yeepay.g3.utils.management.core.annotation.ManagedBean;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.management.openmbean.CompositeData;

@ManagedBean(name="com.yeepay.3g.management:type=YeepayAttribute,name=JVMModel")
public class JVMModel
implements Serializable {
    private static final long serialVersionUID = 6732160053515664460L;
    private static final Logger logger = LoggerFactory.getLogger(JVMModel.class);
    private JmxClient jmxClient = new LocalJmxClient();

    @ManagedAttribute
    public BigDecimal getJvmMemoryUsedRatio() {
        Object object = this.jmxClient.getAttribute("java.lang:type=Memory", "HeapMemoryUsage");
        if (object != null) {
            CompositeData compositeData = (CompositeData)object;
            long usedMemory = (Long)compositeData.get("used");
            long maxMemory = (Long)compositeData.get("max");
            return MathUtils.round(new BigDecimal(MathUtils.divide(usedMemory, maxMemory)));
        }
        return null;
    }

    @ManagedAttribute
    public BigDecimal getJvmPSOldGenUsedRatio() {
        Object object = this.jmxClient.getAttribute("java.lang:type=MemoryPool,name=PS Old Gen", "Usage");
        if (object != null) {
            CompositeData compositeData = (CompositeData)object;
            long usedMemory = (Long)compositeData.get("used");
            long maxMemory = (Long)compositeData.get("max");
            return MathUtils.round(new BigDecimal(MathUtils.divide(usedMemory, maxMemory)));
        }
        return null;
    }

    @ManagedAttribute
    public BigDecimal getJvmPSPermGenUsedRatio() {
        Object object = this.jmxClient.getAttribute("java.lang:type=MemoryPool,name=PS Perm Gen", "Usage");
        if (object != null) {
            CompositeData compositeData = (CompositeData)object;
            long usedMemory = (Long)compositeData.get("used");
            long maxMemory = (Long)compositeData.get("max");
            return MathUtils.round(new BigDecimal(MathUtils.divide(usedMemory, maxMemory)));
        }
        return null;
    }

    @ManagedAttribute
    public long getJvmGCTotalTime() {
        Object object1 = this.jmxClient.getAttribute("java.lang:type=GarbageCollector,name=PS MarkSweep", "CollectionTime");
        Object object2 = this.jmxClient.getAttribute("java.lang:type=GarbageCollector,name=PS Scavenge", "CollectionTime");
        return (Long)object1 + (Long)object2;
    }

    @ManagedAttribute
    public long getJvmGCTotalCount() {
        Object object1 = this.jmxClient.getAttribute("java.lang:type=GarbageCollector,name=PS MarkSweep", "CollectionCount");
        Object object2 = this.jmxClient.getAttribute("java.lang:type=GarbageCollector,name=PS Scavenge", "CollectionCount");
        return (Long)object1 + (Long)object2;
    }
}

