/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.monitor.models.model;

import com.yeepay.g3.utils.common.HttpClientUtil;
import com.yeepay.g3.utils.common.datasource.Config;
import com.yeepay.g3.utils.common.httpclient.MethodType;
import com.yeepay.g3.utils.management.core.annotation.ManagedBean;
import com.yeepay.g3.utils.management.core.annotation.ManagedOperation;
import com.yeepay.g3.utils.management.core.annotation.Param;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@ManagedBean(name="com.yeepay.3g.management:type=YeepayOperation,name=ServerResourceAccessOperation")
public class ServerResourceAccessOperation {
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ManagedOperation
    public Map<String, String> accquireDirAccessProperty(@Param(value="serverDir") String dir) {
        if (dir == null || dir.trim().length() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        File file = new File(dir);
        if (file.exists()) {
            map.put("rwProperty", (file.canRead() ? "R" : "") + (file.canWrite() ? "W" : ""));
            map.put("lastModifyTime", this.simpleDateFormat.format(new Date(file.lastModified())));
            map.put("size", "" + (file.isDirectory() ? "D" : Long.valueOf(file.length())));
            map.put("freespace", "" + file.getFreeSpace());
        }
        return map;
    }

    @ManagedOperation
    public String accquireDnsMappingIP(@Param(value="dns") String dns) {
        try {
            InetAddress address = InetAddress.getByName(dns);
            if (address != null) {
                return address.getHostAddress();
            }
        }
        catch (Exception e) {
            return "UnknownHost";
        }
        return null;
    }

    @ManagedOperation
    public String accquireUrlContent(@Param(value="httpUrl") String url) {
        HttpClientUtil httpClientUtil = new HttpClientUtil();
        try {
            return httpClientUtil.doRequest(MethodType.GET, url, "utf-8");
        }
        catch (Exception e) {
            return "UnknownURL";
        }
    }

    @ManagedOperation
    public boolean accquireDnsConnectStatus(@Param(value="dns") String dns, @Param(value="timeout") int timeout) {
        if (timeout < 1000) {
            timeout = 1000;
        }
        InetAddress address = null;
        boolean flag = false;
        try {
            address = InetAddress.getByName(dns);
            flag = address.isReachable(timeout);
        }
        catch (Exception e) {
            // empty catch block
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public boolean accquireDnsPortConnectStatus(@Param(value="dns") String dns, @Param(value="port") int port, @Param(value="timeout") int timeout) {
        if (timeout < 1000) {
            timeout = 1000;
        }
        InetAddress address = null;
        boolean flag = false;
        try {
            address = InetAddress.getByName(dns);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        Socket soc = new Socket();
        try {
            soc.setSoTimeout(timeout);
            soc.connect(new InetSocketAddress(address, port));
            flag = true;
        }
        catch (Exception e) {
        }
        finally {
            if (soc != null) {
                try {
                    soc.close();
                }
                catch (Exception e) {}
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public boolean accquireDataSourceStatus(@Param(value="dataSourceName") String dataSourceName, @Param(value="timeout") int timeout) {
        String dsFile = "/apps/dbconfig/" + dataSourceName + ".properties";
        File f = new File(dsFile);
        if (!f.exists()) {
            return false;
        }
        FileInputStream is = null;
        Connection conn = null;
        Properties pro = new Properties();
        try {
            is = new FileInputStream(f);
            pro.load(is);
            Config config = Config.instance(pro);
            Class.forName(config.getDriverClass()).newInstance();
            String url = config.getJdbcUrl();
            String user = config.getUser();
            String passwd = config.getPassword();
            conn = DriverManager.getConnection(url, user, passwd);
            boolean bl = conn.isValid(timeout);
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }
}

