/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.monitor.models.util;

import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import com.yeepay.g3.utils.common.monitor.models.model.ApplicationStatusModel;
import com.yeepay.g3.utils.common.monitor.models.model.JVMModel;
import com.yeepay.g3.utils.common.monitor.models.model.ServerResourceAccessOperation;
import com.yeepay.g3.utils.management.core.Registry;

public class InitializationHelper {
    private static final Logger logger = LoggerFactory.getLogger(InitializationHelper.class);
    private static final InitializationHelper instance = new InitializationHelper();

    private InitializationHelper() {
        try {
            this.init();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    public static InitializationHelper getInstance() {
        return instance;
    }

    private void init() {
        this.initAppStatusMonitor();
        this.initServerResourceAccessOperation();
        this.initJVMMonitor();
    }

    private void initAppStatusMonitor() {
        ApplicationStatusModel asm = new ApplicationStatusModel();
        try {
            new Registry((Object)asm).register(true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void initServerResourceAccessOperation() {
        ServerResourceAccessOperation srao = new ServerResourceAccessOperation();
        try {
            new Registry((Object)srao).register(true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void initJVMMonitor() {
        JVMModel jvmModel = new JVMModel();
        try {
            new Registry((Object)jvmModel).register(true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }
}

