/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.page;

import com.yeepay.g3.utils.common.page.Paginator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class PageList<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 5906686481839066126L;
    private Paginator paginator;
    private List<T> data;

    public PageList() {
        this.paginator = new Paginator();
        this.data = new ArrayList<T>();
    }

    public PageList(Collection<T> c) {
        this(c, null);
    }

    public PageList(Collection<T> c, Paginator paginator) {
        this.paginator = paginator == null ? new Paginator() : paginator;
        this.data = new ArrayList<T>();
        if (c != null) {
            this.data.addAll(c);
        }
    }

    public void setPaginator(Paginator paginator) {
        if (paginator != null) {
            this.paginator = paginator;
        }
    }

    public T get(int index) {
        if (index < 0) {
            index = 0;
        }
        return this.data.get(index);
    }

    public int size() {
        return this.data.size();
    }

    public boolean add(T e) {
        if (e != null && e.getClass() == Paginator.class) {
            this.setPaginator((Paginator)e);
        } else {
            this.data.add(e);
        }
        return true;
    }

    public T[] toArray() {
        return this.data.toArray();
    }

    public T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    public Paginator getPaginator() {
        return this.paginator;
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    public ListIterator<T> listIterator() {
        return this.data.listIterator();
    }

    public ListIterator<T> listIterator(int index) {
        return this.data.listIterator(index);
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        if (data != null) {
            this.data = data;
        } else {
            this.data.clear();
        }
    }

    public String toString() {
        return this.paginator + " data : " + this.data.toString();
    }
}

