/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.page;

import java.io.Serializable;

public class Paginator
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3688506614705500726L;
    public static final int DEFAULT_ITEMS_PER_PAGE = 10;
    public static final int DEFAULT_SLIDER_SIZE = 7;
    public static final int UNKNOWN_ITEMS = 0;
    private int page;
    private int totalCount;
    private int pageSize;

    public Paginator() {
        this(0);
    }

    public Paginator(int pageSize) {
        this(pageSize, 0);
    }

    public Paginator(int pageSize, int totalCount) {
        this.totalCount = totalCount >= 0 ? totalCount : 0;
        this.pageSize = pageSize > 0 ? pageSize : 10;
        this.page = this.calcPage(0);
    }

    public int getPages() {
        return (int)Math.ceil((double)this.totalCount / (double)this.pageSize);
    }

    public int getPage() {
        return this.page;
    }

    public int setPage(int page) {
        this.page = this.calcPage(page);
        return this.page;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int setTotalCount(int totalCount) {
        this.totalCount = totalCount >= 0 ? totalCount : 0;
        this.setPage(this.page);
        return this.totalCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int setPageSize(int pageSize) {
        int tmp = this.pageSize;
        this.pageSize = pageSize > 0 ? pageSize : 10;
        this.setPage((int)((double)(this.page - 1) * (double)tmp / (double)this.pageSize) + 1);
        return this.pageSize;
    }

    public int getOffset() {
        return this.page > 0 ? this.pageSize * (this.page - 1) : 0;
    }

    public int getLength() {
        if (this.page > 0) {
            return Math.min(this.pageSize * this.page, this.totalCount) - this.pageSize * (this.page - 1);
        }
        return 0;
    }

    public int getBeginIndex() {
        if (this.page > 0) {
            return this.pageSize * (this.page - 1) + 1;
        }
        return 0;
    }

    public int getEndIndex() {
        if (this.page > 0) {
            return Math.min(this.pageSize * this.page, this.totalCount);
        }
        return 0;
    }

    public int setOffset(int itemOffset) {
        return this.setPage(itemOffset / this.pageSize + 1);
    }

    public int getFirstPage() {
        return this.calcPage(1);
    }

    public int getLastPage() {
        return this.calcPage(this.getPages());
    }

    public int getPreviousPage() {
        return this.calcPage(this.page - 1);
    }

    public int getPreviousPage(int n) {
        return this.calcPage(this.page - n);
    }

    public int getNextPage() {
        return this.calcPage(this.page + 1);
    }

    public int getNextPage(int n) {
        return this.calcPage(this.page + n);
    }

    public boolean isDisabledPage(int page) {
        return page < 1 || page > this.getPages() || page == this.page;
    }

    public int[] getSlider() {
        return this.getSlider(7);
    }

    public int[] getSlider(int width) {
        int pages = this.getPages();
        if (pages < 1 || width < 1) {
            return new int[0];
        }
        if (width > pages) {
            width = pages;
        }
        int[] slider = new int[width];
        int first = this.page - (width - 1) / 2;
        if (first < 1) {
            first = 1;
        }
        if (first + width - 1 > pages) {
            first = pages - width + 1;
        }
        for (int i = 0; i < width; ++i) {
            slider[i] = first + i;
        }
        return slider;
    }

    private int calcPage(int page) {
        int pages = this.getPages();
        if (pages > 0) {
            return page < 1 ? 1 : (page > pages ? pages : page);
        }
        return 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Paginator: page ");
        if (this.getPages() < 1) {
            sb.append(this.getPage());
        } else {
            int[] slider = this.getSlider();
            for (int i = 0; i < slider.length; ++i) {
                if (this.isDisabledPage(slider[i])) {
                    sb.append('[').append(slider[i]).append(']');
                } else {
                    sb.append(slider[i]);
                }
                if (i >= slider.length - 1) continue;
                sb.append('\t');
            }
        }
        sb.append(" of ").append(this.getPages()).append(",\n");
        sb.append("    Showing totalCount ").append(this.getBeginIndex()).append(" to ").append(this.getEndIndex()).append(" (total ").append(this.getTotalCount()).append(" totalCount), ");
        sb.append("offset=").append(this.getOffset()).append(", length=").append(this.getLength());
        return sb.toString();
    }
}

