/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.quota;

import com.yeepay.g3.utils.common.quota.Quota;
import com.yeepay.g3.utils.common.quota.QuotaBean;
import com.yeepay.g3.utils.common.quota.QuotaIsFullException;
import com.yeepay.g3.utils.common.quota.QuotaManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class QuotaControlInvocationHandler
implements InvocationHandler {
    private Object realObj;

    public QuotaControlInvocationHandler(Object realObj) {
        this.realObj = realObj;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Quota quota = method.getAnnotation(Quota.class);
        if (quota == null) {
            return method.invoke(this.realObj, args);
        }
        int quotaNum = quota.quota();
        long timeout = quota.timeout();
        String quotaKey = this.createQuotaKey(method);
        QuotaManager manager = QuotaManager.instance();
        QuotaBean qb = manager.getQuotaBean(quotaKey, quotaNum);
        boolean accquired = true;
        try {
            accquired = qb.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            if (accquired) {
                Object object = method.invoke(this.realObj, args);
                return object;
            }
            throw new QuotaIsFullException("quota of key[ " + quotaKey + " ] is full. totalQuota [ " + quota + " ] ");
        }
        finally {
            if (accquired) {
                qb.release();
            }
        }
    }

    private String createQuotaKey(Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getDeclaringClass().getName()).append("_").append(method.getName()).append("$");
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                Class<?> arg = parameters[i];
                sb.append(arg.getSimpleName()).append("%");
            }
        }
        return sb.toString();
    }
}

