/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.quota;

import com.yeepay.g3.utils.common.ClassUtils;
import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import com.yeepay.g3.utils.common.quota.Quota;
import com.yeepay.g3.utils.common.quota.QuotaBean;
import com.yeepay.g3.utils.common.quota.QuotaIsFullException;
import com.yeepay.g3.utils.common.quota.QuotaManager;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class QuotaInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(QuotaInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Quota quota = ClassUtils.getImplementMethod(invocation.getMethod(), invocation.getThis().getClass()).getAnnotation(Quota.class);
        if (quota == null) {
            return invocation.proceed();
        }
        String quotaKey = this.createQuotaKey(invocation.getMethod());
        logger.debug("has quota indicator. method[ " + quotaKey + "]");
        int quotaNum = quota.quota();
        long timeout = quota.timeout();
        QuotaManager manager = QuotaManager.instance();
        QuotaBean qb = manager.getQuotaBean(quotaKey, quotaNum);
        boolean accquired = true;
        try {
            accquired = qb.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            if (accquired) {
                logger.info("accuire quota success. method[ " + quotaKey + "]");
                Object object = invocation.proceed();
                return object;
            }
            throw new QuotaIsFullException("quota of method[ " + quotaKey + " ] is full. totalQuota [ " + quota + " ] ");
        }
        finally {
            if (accquired) {
                qb.release();
                logger.info("release quota success. method[ " + quotaKey + "]");
            }
        }
    }

    private String createQuotaKey(Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getDeclaringClass().getName()).append("_").append(method.getName()).append("_");
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                Class<?> arg = parameters[i];
                sb.append(arg.getSimpleName()).append("_");
            }
        }
        return sb.toString();
    }
}

