/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.quota;

import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import com.yeepay.g3.utils.common.monitor.ListableServiceMonitor;
import com.yeepay.g3.utils.common.monitor.ServiceMonitorRegister;
import com.yeepay.g3.utils.common.quota.Executable;
import com.yeepay.g3.utils.common.quota.QuotaBean;
import com.yeepay.g3.utils.common.quota.QuotaIsFullException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class QuotaManager {
    private static final Logger logger = LoggerFactory.getLogger(QuotaManager.class);
    private Map<String, QuotaBean> semaphores = new ConcurrentHashMap<String, QuotaBean>();
    private static final QuotaManager manager = new QuotaManager();
    private double alarmThreshold = 0.3333333333333333;

    private QuotaManager() {
        ServiceMonitorRegister.registListableServiceMonitor("quota", new ListableServiceMonitor(){

            @Override
            public List getAllServiceStatus() {
                ArrayList list = new ArrayList();
                for (String key : QuotaManager.this.semaphores.keySet()) {
                    QuotaBean qb = (QuotaBean)QuotaManager.this.semaphores.get(key);
                    HashMap<String, Object> status = new HashMap<String, Object>();
                    status.put("name", key);
                    status.put("running", qb.getPermits() - qb.getSemaphore().availablePermits());
                    status.put("total", qb.getPermits());
                    list.add(status);
                }
                return list;
            }

            @Override
            public Object getServiceStatus(String serviceName) {
                QuotaBean qb = (QuotaBean)QuotaManager.this.semaphores.get(serviceName);
                LinkedHashMap<String, Integer> status = new LinkedHashMap<String, Integer>();
                if (qb != null) {
                    status.put("running", qb.getPermits() - qb.getSemaphore().availablePermits());
                    status.put("total", qb.getPermits());
                }
                return status;
            }
        });
        ServiceMonitorRegister.registListableServiceMonitor("quota-alarm", new ListableServiceMonitor(){

            @Override
            public Object getServiceStatus(String serviceName) {
                return null;
            }

            @Override
            public List getAllServiceStatus() {
                ArrayList list = new ArrayList();
                for (Map.Entry entry : QuotaManager.this.semaphores.entrySet()) {
                    QuotaBean quotaBean = (QuotaBean)entry.getValue();
                    int availablePermits = quotaBean.getSemaphore().availablePermits();
                    int permits = quotaBean.getPermits();
                    int used = permits - availablePermits;
                    double usedRate = (double)used / (double)permits;
                    if (!(usedRate > QuotaManager.this.alarmThreshold)) continue;
                    list.add(entry.getKey());
                }
                HashMap<String, String> hashmap = new HashMap<String, String>();
                hashmap.put("alarm", StringUtils.join(list.iterator(), (String)";"));
                return Arrays.asList(hashmap);
            }
        });
    }

    public static QuotaManager instance() {
        return manager;
    }

    public synchronized QuotaBean getQuotaBean(String key, int quota) {
        QuotaBean qb = this.semaphores.get(key);
        if (qb == null) {
            qb = new QuotaBean(quota);
            this.semaphores.put(key, qb);
        }
        return qb;
    }

    public Object checkQuota(String quotaKey, int quotaNum, Executable executable) {
        logger.debug("check quota key[ " + quotaKey + "] num[" + quotaNum + "]");
        QuotaManager manager = QuotaManager.instance();
        QuotaBean qb = manager.getQuotaBean(quotaKey, quotaNum);
        boolean accquired = false;
        try {
            try {
                accquired = qb.tryAcquire(0L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("tryAcuired was interrupted : " + e.getMessage());
            }
            if (accquired) {
                Object obj;
                logger.info("accuire quota success. method[ " + quotaKey + "]");
                Object object = obj = executable.execute();
                return object;
            }
            throw new QuotaIsFullException("quota of key[ " + quotaKey + " ] is full. max [ " + quotaNum + " ] ");
        }
        finally {
            if (accquired) {
                qb.release();
                logger.debug("release quota success. key[ " + quotaKey + "]");
            }
        }
    }

    public synchronized void removeQuota(String key) {
        this.semaphores.remove(key);
    }

    public synchronized void clear() {
        this.semaphores.clear();
    }
}

