/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.resource;

import com.yeepay.g3.utils.common.exception.YeepayRuntimeException;
import com.yeepay.g3.utils.common.resource.OrderedProperties;
import com.yeepay.g3.utils.common.resource.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyFileResource {
    private Map<String, String> propertyMap = new LinkedHashMap<String, String>();
    private Map<String, Map> filterMap = new LinkedHashMap<String, Map>();

    public String getText(String key) {
        return this.propertyMap.get(key);
    }

    public Map<String, String> getTextMap() {
        return this.propertyMap;
    }

    public Map<String, String> getTextMap(String filter) {
        LinkedHashMap<String, Map> map = this.filterMap.get(filter);
        if (map == null) {
            map = new LinkedHashMap<String, Map>();
            for (String key : this.filterMap.keySet()) {
                if (!key.startsWith(filter)) continue;
                map.put(key.substring(0, filter.length()), this.filterMap.get(key));
            }
            this.filterMap.put(filter, map);
        }
        return map;
    }

    public PropertyFileResource() {
    }

    public PropertyFileResource(String[] resources) {
        for (String name : resources) {
            this.loadFile(name);
        }
    }

    private void loadFile(String resourceName) {
        InputStream inputStream = ResourceLoader.loadResource(resourceName);
        if (inputStream == null) {
            throw new YeepayRuntimeException("resource not found : " + resourceName, new Object[0]);
        }
        OrderedProperties op = new OrderedProperties();
        ArrayList temp = new ArrayList();
        try {
            op.loadList(inputStream, temp);
        }
        catch (IOException e) {
            throw new YeepayRuntimeException("read resource fail : " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        for (AbstractMap.SimpleEntry entry : temp) {
            this.propertyMap.put((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

