/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.resource;

import com.yeepay.g3.utils.common.ValidateUtils;
import com.yeepay.g3.utils.common.resource.PropertyFileResource;
import com.yeepay.g3.utils.common.resource.ResourceLoader;
import java.util.HashMap;
import java.util.Map;

public class PropertyFileResourceUtils {
    private static Map<ClassLoader, Map<String[], PropertyFileResource>> resourceCache = new HashMap<ClassLoader, Map<String[], PropertyFileResource>>();

    private static PropertyFileResource loadCache(String[] resourceNames) {
        Map<String[], PropertyFileResource> classLoaderCache = resourceCache.get(ResourceLoader.getCurrentClassLoader());
        if (classLoaderCache != null) {
            return classLoaderCache.get(resourceNames);
        }
        return null;
    }

    private static void putCache(String[] resourceNames, PropertyFileResource resource) {
        Map<String[], PropertyFileResource> classLoaderCache = resourceCache.get(ResourceLoader.getCurrentClassLoader());
        if (classLoaderCache == null) {
            classLoaderCache = new HashMap<String[], PropertyFileResource>();
        }
        classLoaderCache.put(resourceNames, resource);
    }

    public static PropertyFileResource getPropertyFileResource(String name) {
        return PropertyFileResourceUtils.getPropertyFileResource(new String[]{name});
    }

    public static PropertyFileResource getPropertyFileResource(String[] names) {
        ValidateUtils.checkNotEmpty(names, "resource name must be specified");
        PropertyFileResource resource = PropertyFileResourceUtils.loadCache(names);
        if (resource == null) {
            resource = new PropertyFileResource(names);
            PropertyFileResourceUtils.putCache(names, resource);
        }
        return resource;
    }
}

