/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.threadcontext;

import com.yeepay.g3.utils.common.CommonUtils;
import com.yeepay.g3.utils.common.threadcontext.ThreadContextType;
import java.util.HashMap;
import java.util.Map;

public class ThreadContext {
    private String appName;
    private String threadUID;
    private String newThreadUID;
    private long threadStartTime;
    private ThreadContextType type;
    private Map<String, Object> threadValues;
    private int transferLevelCount = 1;
    private String transferLevel;
    private String preTransferLevel;

    @Deprecated
    public ThreadContext(String a_sourceUID, ThreadContextType a_type) {
        if (a_sourceUID == null || a_sourceUID.trim().length() == 0) {
            this.threadUID = CommonUtils.getUUID();
        } else {
            this.threadUID = a_sourceUID;
            this.newThreadUID = CommonUtils.getUUID();
        }
        this.type = a_type;
    }

    public ThreadContext(String appName, String a_sourceUID, ThreadContextType a_type) {
        this.appName = appName;
        if (a_sourceUID == null || a_sourceUID.trim().length() == 0) {
            this.threadUID = CommonUtils.getUUID();
        } else {
            this.threadUID = a_sourceUID;
            this.newThreadUID = CommonUtils.getUUID();
        }
        this.type = a_type;
    }

    public ThreadContext(String appName, String a_sourceUID, ThreadContextType a_type, String transferLevel) {
        this.appName = appName;
        if (a_sourceUID == null || a_sourceUID.trim().length() == 0) {
            this.threadUID = CommonUtils.getUUID();
        } else {
            this.threadUID = a_sourceUID;
            this.newThreadUID = CommonUtils.getUUID();
        }
        this.type = a_type;
        this.preTransferLevel = transferLevel;
        this.transferLevel = transferLevel;
    }

    public void addValue(String key, Object value) {
        if (this.threadValues == null) {
            this.threadValues = new HashMap<String, Object>();
        }
        this.threadValues.put(key, value);
    }

    public Object getValue(String key) {
        return this.threadValues == null ? null : this.threadValues.get(key);
    }

    public String getTransferLevel() {
        return this.transferLevel;
    }

    public String upTransferLevel() {
        if (this.preTransferLevel.length() == 1) {
            this.transferLevel = this.transferLevelCount++ + ".1";
        } else {
            String prefix = this.preTransferLevel.substring(0, this.preTransferLevel.lastIndexOf(".1"));
            this.transferLevel = prefix + "." + ++this.transferLevelCount + ".1";
        }
        return this.transferLevel;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getThreadUID() {
        return this.threadUID;
    }

    public String getNewThreadUID() {
        return this.newThreadUID;
    }

    public long getThreadStartTime() {
        return this.threadStartTime;
    }

    public ThreadContextType getType() {
        return this.type;
    }

    public void removeValue(String key) {
        if (this.threadValues != null) {
            this.threadValues.remove(key);
        }
    }

    public void removeValue() {
        if (this.threadValues != null) {
            this.threadValues.clear();
        }
    }
}

