/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.tomcat;

import com.yeepay.g3.utils.common.DebugUtils;
import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import com.yeepay.g3.utils.common.monitor.ListableServiceMonitor;
import com.yeepay.g3.utils.common.monitor.ServiceMonitorRegister;
import com.yeepay.g3.utils.common.tomcat.ValveInvocation;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class MonitorValve
extends ValveBase {
    private static final Logger logger = LoggerFactory.getLogger(MonitorValve.class);
    private static final Long DEFAULT_BLOCKING_THRESHOLD = 10000L;
    private static final AtomicLong SEQ = new AtomicLong(0L);
    private static ConcurrentHashMap<ValveInvocation, ValveInvocation> INVOCATIONS = new ConcurrentHashMap();
    private static long blockingThreshold = DEFAULT_BLOCKING_THRESHOLD;

    public static long getBlockingThreshold() {
        return blockingThreshold;
    }

    public static void setBlockingThreshold(long blockingThreshold) {
        MonitorValve.blockingThreshold = blockingThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        ValveInvocation invocation = this.open(request, response);
        try {
            INVOCATIONS.put(invocation, invocation);
            long now = System.currentTimeMillis();
            this.getNext().invoke(request, response);
            long timespan = System.currentTimeMillis() - now;
            if (blockingThreshold != -1L && blockingThreshold < timespan && logger.isInfoEnabled()) {
                logger.info("invoke url use " + timespan + " miniseconds.");
            }
        }
        finally {
            this.release(invocation);
        }
    }

    protected ValveInvocation open(Request request, Response response) {
        ValveInvocation invocation = new ValveInvocation();
        invocation.setId(SEQ.incrementAndGet());
        invocation.setInvokeThread(Thread.currentThread());
        invocation.setInvokeTime(System.currentTimeMillis());
        invocation.setInvokeUrl(request.getRequestURL() + "?" + request.getQueryString());
        return invocation;
    }

    protected void release(ValveInvocation invocation) {
        INVOCATIONS.remove(invocation);
    }

    protected static void registerToMonitor() {
        ServiceMonitorRegister.registListableServiceMonitor("tomcat-monitor-valve-summary", new ListableServiceMonitor(){

            @Override
            public Object getServiceStatus(String serviceName) {
                return null;
            }

            @Override
            public List<?> getAllServiceStatus() {
                long now = System.currentTimeMillis();
                long blockingCount = INVOCATIONS.size();
                long blockingAlarmCount = 0L;
                for (ValveInvocation invocation : INVOCATIONS.values()) {
                    if (now - invocation.getInvokeTime() < blockingThreshold) continue;
                    ++blockingAlarmCount;
                }
                HashMap<String, Long> item = new HashMap<String, Long>();
                item.put("blockingCount", blockingCount);
                item.put("blockingAlarmCount", blockingAlarmCount);
                return Arrays.asList(item);
            }
        });
        ServiceMonitorRegister.registListableServiceMonitor("tomcat-monitor-valve", new ListableServiceMonitor(){

            @Override
            public Object getServiceStatus(String serviceName) {
                return null;
            }

            @Override
            public List<?> getAllServiceStatus() {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:S");
                long now = System.currentTimeMillis();
                ArrayList list = new ArrayList();
                if (blockingThreshold == -1L) {
                    return list;
                }
                for (ValveInvocation invocation : INVOCATIONS.values()) {
                    if (now - invocation.getInvokeTime() < blockingThreshold) continue;
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    item.put("id", invocation.getId());
                    item.put("thread-id", invocation.getInvokeThread().getId());
                    item.put("thread-name", invocation.getInvokeThread().getName());
                    item.put("thread-stacktrace", DebugUtils.getStackTrace(invocation.getInvokeThread().getStackTrace()));
                    item.put("invoke-time", format.format(new Date(invocation.getInvokeTime())));
                    item.put("alive-time", now - invocation.getInvokeTime());
                    item.put("invoke-url", invocation.getInvokeUrl());
                    list.add(item);
                }
                return list;
            }
        });
    }

    static {
        MonitorValve.registerToMonitor();
    }
}

