/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.tomcat;

import com.yeepay.g3.utils.common.CommonUtils;
import com.yeepay.g3.utils.common.StringUtils;
import com.yeepay.g3.utils.common.ThreadContextUtils;
import com.yeepay.g3.utils.common.threadcontext.ThreadContextType;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class ThreadContextValve
extends ValveBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String transferLevel;
        String guid;
        if (ThreadContextUtils.contextInitialized()) {
            ThreadContextUtils.clearContext();
        }
        if ((guid = request.getHeader("_thread_uid")) == null || guid.trim().length() == 0) {
            guid = CommonUtils.getUUID();
        }
        ThreadContextType conextType = ThreadContextType.WEB;
        String contentType = request.getContentType();
        if ("x-application/hessian".equalsIgnoreCase(contentType) || "application/x-java-serialized-object".equalsIgnoreCase(contentType)) {
            conextType = ThreadContextType.INTERFACE;
        }
        transferLevel = StringUtils.isBlank((String)(transferLevel = request.getHeader("_transfer_level"))) ? "1" : transferLevel;
        ThreadContextUtils.initContext(this.getAppName(request), guid, conextType, transferLevel);
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            ThreadContextUtils.clearContext();
        }
    }

    private String getAppName(Request request) {
        return StringUtils.replace((String)request.getContextPath(), (String)"/", (String)"");
    }
}

