/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.payplus.core;

import com.yeepay.g3.sdk.yop.client.YopClient;
import com.yeepay.g3.sdk.yop.client.YopRequest;
import com.yeepay.g3.sdk.yop.client.YopResponse;
import com.yeepay.g3.sdk.yop.error.YopError;
import com.yeepay.g3.sdk.yop.error.YopSubError;
import com.yeepay.g3.utils.common.json.JSONException;
import com.yeepay.g3.utils.common.json.JSONObject;
import com.yeepay.payplus.bo.BaseBO;
import com.yeepay.payplus.core.entity.PayplusResp;
import com.yeepay.payplus.exception.PayplusConfigException;
import com.yeepay.payplus.util.PayplusConfig;
import com.yeepay.payplus.util.PayplusUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.log4j.Logger;

public class PayplusConnector {
    private Logger logger = Logger.getLogger(PayplusConnector.class);
    private YopRequest request;

    public PayplusConnector(String path) {
        PayplusConfig.init(path);
        this.instanceYOPRequest(PayplusConfig.APP_KEY, PayplusConfig.APP_SECRET, PayplusConfig.ADDRESS, PayplusConfig.SIGN_ALGORITHM);
    }

    public PayplusConnector() {
        PayplusConfig.init(null);
        this.instanceYOPRequest(PayplusConfig.APP_KEY, PayplusConfig.APP_SECRET, PayplusConfig.ADDRESS, PayplusConfig.SIGN_ALGORITHM);
    }

    public PayplusConnector(String appKey, String appSecret) {
        PayplusConfig.init(null);
        if (PayplusConfig.MODEL.equals("CUSTOMERS")) {
            throw new PayplusConfigException("DEPRECATED, PLEASE USING THE CONSTRUCTOR WITHOUT PARAMETERS OR WITHIN A PATH PARAMETER.");
        }
        this.instanceYOPRequest(appKey, appSecret, PayplusConfig.ADDRESS, PayplusConfig.SIGN_ALGORITHM);
    }

    private void instanceYOPRequest(String appKey, String appSecret, String url, String signAlgorithm) {
        this.request = new YopRequest(appKey, appSecret, url);
        this.request.setEncrypt(true);
        this.request.setSignRet(true);
        this.request.setSignAlg(signAlgorithm);
    }

    private String formattedRequestParameters(Map<String, String> paras, String uri) {
        Set<String> keys = paras.keySet();
        StringBuilder parameters = new StringBuilder("\n[Request of Payplus]\n");
        uri = uri.substring(uri.indexOf("payplus") + 8);
        parameters.append("service: " + uri + "\n");
        for (String key : keys) {
            String value = paras.get(key);
            if (PayplusUtil.isNull(value).booleanValue()) continue;
            parameters.append(key + ": " + value + "\n");
        }
        return parameters.toString();
    }

    public PayplusResp call(String uri, Map<String, String> paras) {
        PayplusResp payplusResp = new PayplusResp();
        this.setUpYOPRequest(this.request, paras);
        if (paras.containsKey("requestNo")) {
            payplusResp.setRequestNo(paras.get("requestNo"));
        } else if (paras.containsKey("activeNo")) {
            payplusResp.setActiveNo(paras.get("activeNo"));
        }
        this.logger.debug((Object)this.formattedRequestParameters(paras, uri));
        YopResponse resp = YopClient.post(uri, this.request);
        String state = resp.getState();
        JSONObject jo = null;
        if ("FAILURE".equals(state)) {
            YopError err = resp.getError();
            try {
                jo = new JSONObject();
                jo.put("code", err.getCode());
                jo.put("message", err.getMessage());
                JSONObject subErr = new JSONObject();
                List<YopSubError> errList = err.getSubErrors();
                for (YopSubError yopSubError : errList) {
                    subErr.put(yopSubError.getCode(), yopSubError.getMessage());
                }
                jo.put("subErrors", subErr);
                payplusResp.setRespInfo(jo.toString(2));
                payplusResp.setState(0);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if ("SUCCESS".equals(state)) {
            try {
                jo = new JSONObject(resp.getStringResult());
                if (jo.has("redirectUrl")) {
                    payplusResp.setKeyInfo(String.valueOf(jo.get("redirectUrl")));
                }
                payplusResp.setRespInfo(jo.toString(2));
                payplusResp.setState(1);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return payplusResp;
    }

    public PayplusResp call(String uri, BaseBO bo) {
        return this.call(uri, this.convert2Map(bo));
    }

    private Map<String, String> convert2Map(BaseBO bo) {
        HashMap<String, String> params = new HashMap<String, String>(0);
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors((Object)bo);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if ("class".equals(name)) continue;
                params.put(name, String.valueOf(propertyUtilsBean.getNestedProperty((Object)bo, name)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    private void insertDefaultParameters(Map<String, String> paraMap) {
        String merchantNo;
        String requestNo;
        if (PayplusConfig.MODEL.equals("CUSTOMERS")) {
            return;
        }
        if (paraMap.containsKey("requestNo") && PayplusUtil.isNull(requestNo = paraMap.get("requestNo")).booleanValue()) {
            paraMap.put("requestNo", PayplusUtil.genRequestNo());
        }
        if (paraMap.containsKey("merchantNo") && PayplusUtil.isNull(merchantNo = paraMap.get("merchantNo")).booleanValue()) {
            paraMap.put("merchantNo", PayplusConfig.MERCHANT_NO);
        }
        if (paraMap.containsKey("serverCallbackUrl") && PayplusUtil.isNull(requestNo = paraMap.get("serverCallbackUrl")).booleanValue()) {
            paraMap.put("serverCallbackUrl", "http://payplus.yeepay.com");
        }
        if (paraMap.containsKey("webCallbackUrl") && PayplusUtil.isNull(requestNo = paraMap.get("webCallbackUrl")).booleanValue()) {
            paraMap.put("webCallbackUrl", "http://payplus.yeepay.com");
        }
        if (paraMap.containsKey("webCallBackUrl") && PayplusUtil.isNull(requestNo = paraMap.get("webCallBackUrl")).booleanValue()) {
            paraMap.put("webCallBackUrl", "http://payplus.yeepay.com");
        }
        if (paraMap.containsKey("returnUrl") && PayplusUtil.isNull(requestNo = paraMap.get("returnUrl")).booleanValue()) {
            paraMap.put("returnUrl", "http://payplus.yeepay.com");
        }
    }

    private void setUpYOPRequest(YopRequest request, Map<String, String> paraMap) {
        this.insertDefaultParameters(paraMap);
        Set<String> keys = paraMap.keySet();
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            String key;
            String value = paraMap.get(key = it.next());
            request.addParam(key, value == null || value == "null" ? "" : value);
        }
    }

    private void convert2Map(Field[] fields, Map paraMap, Class subBO, BaseBO bo) {
        for (Field f : fields) {
            String methodName = f.getName();
            String getter = "get" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
            Object value = null;
            try {
                Method m = subBO.getMethod(getter, new Class[0]);
                value = m.invoke((Object)bo, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            paraMap.put(methodName, String.valueOf(value));
        }
    }
}

