/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.payplus.util;

import com.yeepay.payplus.exception.PayplusConfigException;
import com.yeepay.payplus.util.PayplusUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class PayplusConfig {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String GENERAL_URL = "http://payplus.yeepay.com";
    public static final String JOEY_TRIBBIANI = "Joey";
    public static final String MONICA_GELLER = "Monica";
    public static final String PHOEBE_BUFFAY = "Phoebe";
    public static final String ROSS_GELLER = "Ross";
    public static final String CHANDLER_BING = "Chandler";
    public static final String RACHEL_GREEN = "Rachel";
    public static final String YANGYANG1 = "yangyang1";
    public static String APP_KEY;
    public static String APP_SECRET;
    public static String SIGN_ALGORITHM;
    public static String ADDRESS;
    public static String MERCHANT_NO;
    public static String MODEL;
    public static String MODEL_CUSTOMERS;

    private static ResourceBundle getResourceOBJ() {
        ResourceBundle payplusConfig = null;
        try {
            payplusConfig = ResourceBundle.getBundle("payplus");
        }
        catch (MissingResourceException mre) {
            throw new PayplusConfigException("PLEASE SET UP A \"payplus.properties\" FOR USING THIS UTILITY.");
        }
        return payplusConfig;
    }

    private static ResourceBundle getResourceOBJ(String path) {
        PropertyResourceBundle payplusConfig = null;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));
            payplusConfig = new PropertyResourceBundle(in);
        }
        catch (FileNotFoundException e) {
            throw new PayplusConfigException("CANNOT FIND A \"PAYPLUS.PROPERTIES\" THROUGH CHECK THE PATH PROVIDED.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return payplusConfig;
    }

    private static void acquireCustomersConfig(ResourceBundle payplusConfig) {
        MODEL_CUSTOMERS = payplusConfig.getString("MODEL");
        if (MODEL_CUSTOMERS.equals("TEST")) {
            return;
        }
        if (MODEL_CUSTOMERS.equals("PRODUCTION")) {
            try {
                APP_KEY = payplusConfig.getString("APP_KEY");
                APP_SECRET = payplusConfig.getString("APP_SECRET");
            }
            catch (MissingResourceException mre) {
                throw new PayplusConfigException("1 - Please set up APP_KEY and APP_SECRET in payplus.properties.");
            }
            if (PayplusUtil.isNull(APP_KEY).booleanValue() || PayplusUtil.isNull(APP_SECRET).booleanValue()) {
                throw new PayplusConfigException("2 - Please set up APP_KEY and APP_SECRET in payplus.properties.");
            }
            MERCHANT_NO = APP_KEY;
        }
    }

    private static void loadDefaultConfig() {
        ResourceBundle rb = ResourceBundle.getBundle("cfg");
        MODEL = rb.getString("MODEL");
        ADDRESS = rb.getString("ADDRESS");
        APP_KEY = rb.getString("APP_KEY");
        APP_SECRET = rb.getString("APP_SECRET");
        MERCHANT_NO = rb.getString("MERCHANT_NO");
        SIGN_ALGORITHM = rb.getString("SIGN_ALGORITHM");
    }

    public static void init(String path) {
        PayplusConfig.loadDefaultConfig();
        if (MODEL.equals("CUSTOMERS")) {
            if (PayplusUtil.isNull(path).booleanValue()) {
                PayplusConfig.acquireCustomersConfig(PayplusConfig.getResourceOBJ());
            } else {
                PayplusConfig.acquireCustomersConfig(PayplusConfig.getResourceOBJ(path));
            }
        }
    }
}

