/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.payplus.util;

import com.yeepay.g3.utils.common.json.JSONArray;
import com.yeepay.g3.utils.common.json.JSONObject;
import com.yeepay.payplus.core.entity.PayplusResp;
import com.yeepay.payplus.exception.QRCodeException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class PayplusUtil {
    private static Logger logger = Logger.getLogger(PayplusUtil.class);

    public static String genRequestNo() {
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        return uuid;
    }

    public static void main(String[] args) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        HashMap<String, String> remitInfosMap = new HashMap<String, String>();
        remitInfosMap.put("remiteType", "AMOUNT");
        remitInfosMap.put("bankCode", "CMB");
        remitInfosMap.put("bankName", "\u62db\u5546\u94f6\u884c");
        remitInfosMap.put("branchBankName", "");
        remitInfosMap.put("userName", "\u6768\u6d0b");
        remitInfosMap.put("cardNo", "6214850107101245");
        remitInfosMap.put("bankAccountType", "pr");
        remitInfosMap.put("province", "110000");
        remitInfosMap.put("city", "110000");
        remitInfosMap.put("payeeMobile", "18514591959");
        remitInfosMap.put("leaveWord", "\u6613\u5b9d\u6d4b\u8bd5");
        remitInfosMap.put("value", "0.01");
        list.add(PayplusUtil.convert2Json(remitInfosMap));
        JSONArray ja = new JSONArray(list);
        System.out.println(ja);
    }

    public static JSONObject convert2Json(Map<String, String> map) {
        JSONObject jo = new JSONObject(map);
        return jo;
    }

    public static String convert2JsonString(Map<String, String> map) {
        JSONObject jo = new JSONObject(map);
        return jo.toString();
    }

    public static String convert2JsonArray(List<JSONObject> list) {
        JSONArray jo = new JSONArray(list);
        logger.debug((Object)jo);
        return jo.toString();
    }

    public static String getFormatDateString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static Boolean isNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            String str = String.valueOf(obj);
            if ("null".equals(str) || "".equals(str)) {
                return true;
            }
            return false;
        }
        logger.error((Object)("other class type: " + obj.getClass().getName()));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBase64Stream(String path) {
        File file = new File(path);
        FileInputStream fs = null;
        ByteBuffer byteBuffer = null;
        try {
            fs = new FileInputStream(file);
            FileChannel channel = fs.getChannel();
            byteBuffer = ByteBuffer.allocate((int)channel.size());
            channel.read(byteBuffer);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String base64FileStr = Base64.encodeBase64String((byte[])byteBuffer.array());
        return base64FileStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void genQRCodeImage(PayplusResp trophy, String path) {
        if (trophy == null || trophy.getKeyInfo() == null || "".equals(trophy.getKeyInfo()) || trophy.getKeyInfo().contains("https://")) {
            throw new QRCodeException("\n\nHi buddy, please kindly check: \n 1, The request got correct return. \n 2, The service you called will send you QR code back. \n");
        }
        String hexImgString = trophy.getKeyInfo();
        byte[] b = PayplusUtil.hex2byte(hexImgString);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        BufferedImage image = null;
        try {
            image = ImageIO.read(in);
            ImageIO.write((RenderedImage)image, "jpg", new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static byte[] hex2byte(String s) {
        byte[] src = s.toLowerCase().getBytes();
        byte[] ret = new byte[src.length / 2];
        for (int i = 0; i < src.length; i += 2) {
            byte hi = src[i];
            byte low = src[i + 1];
            hi = (byte)(hi >= 97 && hi <= 102 ? 10 + (hi - 97) : hi - 48);
            low = (byte)(low >= 97 && low <= 102 ? 10 + (low - 97) : low - 48);
            ret[i / 2] = (byte)(hi << 4 | low);
        }
        return ret;
    }
}

