/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.BooleanUtil;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.enums.ExecuteableTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.exception.FlowSystemException;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.ArrayList;
import java.util.List;

public class Chain
implements Executable {
    private static final LFLog LOG = LFLoggerManager.getLogger(Chain.class);
    private String chainId;
    private Executable routeItem;
    private List<Condition> conditionList = new ArrayList<Condition>();
    private String el;
    private boolean isCompiled = true;
    private String namespace;

    public Chain(String chainName) {
        this.chainId = chainName;
    }

    public Chain() {
    }

    public Chain(String chainName, List<Condition> conditionList) {
        this.chainId = chainName;
        this.conditionList = conditionList;
    }

    public List<Condition> getConditionList() {
        return this.conditionList;
    }

    public void setConditionList(List<Condition> conditionList) {
        this.conditionList = conditionList;
    }

    @Deprecated
    public String getChainName() {
        return this.chainId;
    }

    public void setChainName(String chainName) {
        this.chainId = chainName;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    @Override
    public void execute(Integer slotIndex) throws Exception {
        if (BooleanUtil.isFalse((Boolean)this.isCompiled)) {
            LiteFlowChainELBuilder.buildUnCompileChain(this);
        }
        if (CollUtil.isEmpty(this.conditionList)) {
            throw new FlowSystemException("no conditionList in this chain[" + this.chainId + "]");
        }
        Slot slot = DataBus.getSlot(slotIndex);
        try {
            slot.setChainId(this.chainId);
            for (Condition condition : this.conditionList) {
                condition.setCurrChainId(this.chainId);
                condition.execute(slotIndex);
            }
        }
        catch (ChainEndException e) {
            throw e;
        }
        catch (Exception e) {
            if (slot.isSubChain(this.chainId)) {
                slot.setSubException(this.chainId, e);
            } else {
                slot.setException(e);
            }
            throw e;
        }
    }

    public void executeRoute(Integer slotIndex) throws Exception {
        if (this.routeItem == null) {
            throw new FlowSystemException("no route condition or node in this chain[" + this.chainId + "]");
        }
        Slot slot = DataBus.getSlot(slotIndex);
        try {
            slot.setChainId(this.chainId);
            this.routeItem.setCurrChainId(this.chainId);
            this.routeItem.execute(slotIndex);
            boolean routeResult = (Boolean)this.routeItem.getItemResultMetaValue(slotIndex);
            slot.setRouteResult(routeResult);
        }
        catch (ChainEndException e) {
            throw e;
        }
        catch (Exception e) {
            slot.setException(e);
            throw e;
        }
    }

    @Override
    public ExecuteableTypeEnum getExecuteType() {
        return ExecuteableTypeEnum.CHAIN;
    }

    @Override
    public void setId(String id) {
        this.chainId = id;
    }

    @Override
    public String getId() {
        return this.chainId;
    }

    @Override
    public void setTag(String tag) {
    }

    @Override
    public String getTag() {
        return null;
    }

    public Executable getRouteItem() {
        return this.routeItem;
    }

    public void setRouteItem(Executable routeItem) {
        this.routeItem = routeItem;
    }

    public String getEl() {
        return this.el;
    }

    public void setEl(String el) {
        this.el = el;
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public void setCompiled(boolean compiled) {
        this.isCompiled = compiled;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

