/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.process.impl;

import cn.hutool.core.collection.CollStreamUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.util.AnnoUtil;
import com.yomahub.liteflow.process.LiteflowScannerProcessStep;
import com.yomahub.liteflow.process.context.LiteflowScannerProcessStepContext;
import com.yomahub.liteflow.process.enums.LiteflowScannerProcessStepEnum;
import com.yomahub.liteflow.script.ScriptBeanManager;
import com.yomahub.liteflow.script.annotation.ScriptMethod;
import com.yomahub.liteflow.script.proxy.ScriptMethodProxy;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptMethodBeanProcess
implements LiteflowScannerProcessStep {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptMethodBeanProcess.class);

    @Override
    public boolean filter(LiteflowScannerProcessStepContext ctx) {
        Class clazz = ctx.getClazz();
        List outPut = Arrays.stream(clazz.getMethods()).filter((? super T method) -> {
            ScriptMethod scriptMethod = (ScriptMethod)AnnoUtil.getAnnotation((AnnotatedElement)method, ScriptMethod.class);
            return ObjectUtil.isNotNull((Object)scriptMethod) && StrUtil.isNotEmpty((CharSequence)scriptMethod.value());
        }).collect(Collectors.toList());
        ctx.setOutPut(outPut);
        return CollUtil.isNotEmpty(outPut);
    }

    @Override
    public Object postProcessAfterInitialization(LiteflowScannerProcessStepContext ctx) {
        Class clazz = ctx.getClazz();
        String beanName = ctx.getBeanName();
        Object bean = ctx.getBean();
        List scriptMethods = (List)ctx.getOutPut();
        LOG.info("script method[{}] has been found", (Object)beanName);
        Map scriptMethodsGroupByValue = CollStreamUtil.groupBy((Collection)scriptMethods, method -> {
            ScriptMethod scriptMethod = (ScriptMethod)AnnoUtil.getAnnotation((AnnotatedElement)method, ScriptMethod.class);
            return scriptMethod.value();
        }, Collectors.toList());
        for (Map.Entry entry : scriptMethodsGroupByValue.entrySet()) {
            String key = (String)entry.getKey();
            List methods = (List)entry.getValue();
            ScriptMethodProxy proxy = new ScriptMethodProxy(bean, clazz, methods);
            ScriptBeanManager.addScriptBean((String)key, (Object)proxy.getProxyScriptMethod());
        }
        return bean;
    }

    @Override
    public LiteflowScannerProcessStepEnum type() {
        return LiteflowScannerProcessStepEnum.SCRIPT_METHOD_BEAN;
    }
}

