/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.core.context;

import org.apache.logging.log4j.ThreadContext;

public class AspectLogContext {
    private static InheritableThreadLocal<String> logValueTL = new InheritableThreadLocal();

    public static void putLogValue(String logValue) {
        logValueTL.set(logValue);
        if (AspectLogContext.isLog4j2AsyncLoggerContextSelector()) {
            ThreadContext.put((String)"log_thread_context_label", (String)logValue);
        }
    }

    public static String getLogValue() {
        String result = (String)logValueTL.get();
        if (AspectLogContext.isLog4j2AsyncLoggerContextSelector()) {
            result = ThreadContext.get((String)"log_thread_context_label");
        }
        return result;
    }

    public static void remove() {
        logValueTL.remove();
        if (AspectLogContext.isLog4j2AsyncLoggerContextSelector()) {
            ThreadContext.remove((String)"log_thread_context_label");
        }
    }

    private static boolean isLog4j2AsyncLoggerContextSelector() {
        return "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector".equals(System.getProperty("Log4jContextSelector"));
    }
}

