/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.core.mq;

import cn.hutool.core.net.NetUtil;
import com.yomahub.tlog.context.SpanIdGenerator;
import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.core.rpc.TLogLabelBean;
import com.yomahub.tlog.spring.TLogSpringAware;
import java.net.InetAddress;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLogMqWrapBean<T>
extends TLogLabelBean {
    private static final Logger log = LoggerFactory.getLogger(TLogMqWrapBean.class);
    private T t;

    public TLogMqWrapBean(T t) {
        this.t = t;
        String traceId = TLogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            String appName = TLogSpringAware.getProperty((String)"spring.application.name");
            String ip = NetUtil.getLocalhostStr();
            String hostName = "NONE";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setTraceId(traceId);
            this.setPreIvkApp(appName);
            this.setPreIvkHost(hostName);
            this.setPreIp(ip);
            this.setSpanId(SpanIdGenerator.generateNextSpanId());
        } else {
            log.warn("[TLOG]\u672c\u5730kafka\u5ba2\u6237\u7aef\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u53d1\u9001\u4e0d\u4f20\u9012traceId");
        }
    }

    public T getT() {
        return this.t;
    }

    public void setT(T t) {
        this.t = t;
    }
}

