/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.core.rpc;

import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.context.TLogLabelGenerator;
import com.yomahub.tlog.core.context.AspectLogContext;
import com.yomahub.tlog.core.rpc.TLogLabelBean;
import com.yomahub.tlog.id.TLogIdGeneratorLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TLogRPCHandler {
    protected static final Logger log = LoggerFactory.getLogger(TLogRPCHandler.class);

    public void processProviderSide(TLogLabelBean labelBean) {
        if (StringUtils.isBlank((CharSequence)labelBean.getPreIvkApp())) {
            labelBean.setPreIvkApp("NONE");
        }
        TLogContext.putPreIvkApp((String)labelBean.getPreIvkApp());
        if (StringUtils.isBlank((CharSequence)labelBean.getPreIvkHost())) {
            labelBean.setPreIvkHost("NONE");
        }
        TLogContext.putPreIvkHost((String)labelBean.getPreIvkHost());
        if (StringUtils.isBlank((CharSequence)labelBean.getPreIp())) {
            labelBean.setPreIp("NONE");
        }
        TLogContext.putPreIp((String)labelBean.getPreIp());
        if (StringUtils.isBlank((CharSequence)labelBean.getTraceId())) {
            labelBean.setTraceId(TLogIdGeneratorLoader.getIdGenerator().generateTraceId());
            log.debug("[TLOG]\u53ef\u80fd\u4e0a\u4e00\u4e2a\u8282\u70b9[{}]\u6ca1\u6709\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u91cd\u65b0\u751f\u6210traceId[{}]", (Object)labelBean.getPreIvkApp(), (Object)labelBean.getTraceId());
        }
        TLogContext.putSpanId((String)labelBean.getSpanId());
        TLogContext.putTraceId((String)labelBean.getTraceId());
        String tlogLabel = TLogLabelGenerator.generateTLogLabel((String)labelBean.getPreIvkApp(), (String)labelBean.getPreIvkHost(), (String)labelBean.getPreIp(), (String)labelBean.getTraceId(), (String)TLogContext.getSpanId());
        AspectLogContext.putLogValue(tlogLabel);
        if (TLogContext.hasTLogMDC()) {
            MDC.put((String)"tl", (String)tlogLabel);
        }
    }

    public void cleanThreadLocal() {
        TLogContext.removePreIvkApp();
        TLogContext.removePreIvkHost();
        TLogContext.removePreIp();
        TLogContext.removeTraceId();
        TLogContext.removeSpanId();
        AspectLogContext.remove();
        if (TLogContext.hasTLogMDC()) {
            MDC.remove((String)"tl");
        }
    }
}

