/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.service.impl;

import com.yqbsoft.laser.service.searchengine.service.IConnection;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.suppercore.supper.SupBaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.stereotype.Service;

@Service(value="esConnection")
public class ESConnection
extends SupBaseServiceImpl
implements IConnection {
    private static final String CLASS_CODE = "es.ESConnectionImpl";
    private final String SERVER_DELIMITER = ";";
    private final String PORT_DELIMITER = ":";
    private String protocalType = "http";
    private Map<String, HttpHost[]> cachedCluster = new HashMap<String, HttpHost[]>();
    private RestHighLevelClient client;
    private Lock reentrantLock = new ReentrantLock();

    @Override
    public RestHighLevelClient getConnection() {
        if (this.client == null) {
            try {
                this.reentrantLock.lock();
                if (this.client == null) {
                    Long ts1 = System.currentTimeMillis();
                    this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])this.getHosts()));
                    this.logger.debug("es.ESConnectionImplget connection takes:" + (System.currentTimeMillis() - ts1));
                }
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
        return this.client;
    }

    private HttpHost[] getHosts() {
        HttpHost[] hh = null;
        try {
            ResourceBundle resourceBundle = RegeditUtil.getResourceBundle((String)"search", (String)"appres.path", (String)"");
            if (StringUtils.isNotBlank((String)resourceBundle.getString("url")) && StringUtils.isNotBlank((String)resourceBundle.getString("port"))) {
                String serverCluster = resourceBundle.getString("url") + ":" + resourceBundle.getString("port");
                if (serverCluster == null) {
                    throw new RuntimeException("ES\u641c\u7d22\u96c6\u7fa4\u672a\u914d\u7f6e");
                }
                hh = this.cachedCluster.get(serverCluster);
                if (hh != null) {
                    this.logger.debug("\u7f13\u5b58\u4e2d\u83b7\u53d6ES\u96c6\u7fa4\u5217\u8868");
                    return hh;
                }
                String[] servers = serverCluster.split(";");
                hh = new HttpHost[servers.length];
                int i = 0;
                for (String server : servers) {
                    String[] sp = server.split(":");
                    hh[i] = new HttpHost(sp[0], Integer.parseInt(sp[1]), this.protocalType);
                    ++i;
                }
                this.cachedCluster.put(serverCluster, hh);
            }
        }
        catch (Exception e) {
            this.logger.error("EsUtil.httpUrlGet.e1", (Object)e.getMessage(), (Throwable)e);
        }
        return hh;
    }

    @Override
    public void closeConnection(RestHighLevelClient client) {
    }
}

