/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.util.alipay.util;

import com.qianjiang.common.util.alipay.util.AlipayConfig;
import com.qianjiang.util.MyLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;

public class AlipayCore {
    public static final MyLogger LOGGER = new MyLogger(AlipayCore.class);

    private AlipayCore() {
    }

    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (sArray == null || sArray.isEmpty()) {
            return result;
        }
        for (String key : sArray.keySet()) {
            String value = sArray.get(key);
            if (value == null || "".equals(value) || "sign".equalsIgnoreCase(key) || "sign_type".equalsIgnoreCase(key)) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logResult(String sWord) {
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(AlipayConfig.log_path + "alipay_log_" + System.currentTimeMillis() + ".txt");
            writer.write(sWord);
        }
        catch (Exception e) {
            LOGGER.error("" + e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.error("" + e);
                }
            }
        }
    }

    public static String getAbstract(String strFilePath, String fileDigestType) throws IOException {
        FilePartSource file = new FilePartSource(new File(strFilePath));
        if ("MD5".equals(fileDigestType)) {
            return DigestUtils.md5Hex((InputStream)file.createInputStream());
        }
        if ("SHA".equals(fileDigestType)) {
            return DigestUtils.sha256Hex((InputStream)file.createInputStream());
        }
        return "";
    }
}

