/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.exception;

import com.qianjiang.system.exception.ExceptionNumber;
import com.qianjiang.util.MyLogger;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class CMyException
extends Exception {
    private static final MyLogger LOGGER = new MyLogger(CMyException.class);
    private static final long serialVersionUID = 1382601970702567028L;
    private static final String ARROWS = "<-- ";
    public int errNo = 0;
    public final Throwable rootCause;

    public CMyException(int errNo) {
        this.rootCause = null;
        this.errNo = errNo;
    }

    public CMyException(int errNo, String sMsg) {
        super(sMsg);
        this.rootCause = null;
        this.errNo = errNo;
    }

    public CMyException(String sMsg) {
        super(sMsg);
        this.errNo = 0;
        this.rootCause = null;
    }

    public CMyException(int errNo, String sMsg, Throwable rootCause) {
        super(sMsg);
        this.errNo = errNo;
        this.rootCause = rootCause;
    }

    public CMyException(String sMsg, Throwable rootCause) {
        super(sMsg);
        this.errNo = 0;
        this.rootCause = rootCause;
    }

    public int getErrNo() {
        return this.errNo;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String getErrNoMsg() {
        return ExceptionNumber.getErrNoMsg(this.errNo);
    }

    public String getMyMessage() {
        return super.getMessage();
    }

    @Override
    public String toString() {
        return "[ERR-" + this.errNo + "] " + this.getMyMessage();
    }

    @Override
    public String getMessage() {
        String sMessage = this.toString();
        if (this.rootCause != null) {
            sMessage = sMessage + "\r\n<-- " + this.rootCause.toString();
        }
        return sMessage;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        if (this.rootCause == null) {
            super.printStackTrace(ps);
        } else {
            Throwable root = this.rootCause;
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(this.toString());
                while (root instanceof CMyException) {
                    ps.println(ARROWS + root.toString());
                    if ((root = ((CMyException)root).getRootCause()) != null) continue;
                    LOGGER.error(ps.toString());
                    break;
                }
                if (root != null) {
                    ps.print(ARROWS);
                    LOGGER.error(ps.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        if (this.rootCause == null) {
            super.printStackTrace(pw);
        } else {
            Throwable root = this.rootCause;
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                pw.println(this.toString());
                Throwable preRoot = null;
                while (root instanceof CMyException) {
                    pw.print(ARROWS);
                    preRoot = root;
                    root = ((CMyException)root).getRootCause();
                    if (root == null) {
                        LOGGER.error(pw.toString());
                        break;
                    }
                    pw.println(preRoot.toString());
                }
                if (root != null) {
                    pw.print(ARROWS);
                    LOGGER.error(pw.toString());
                }
            }
        }
    }

    public String getStackTraceText() {
        return CMyException.getStackTraceText(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTraceText(Throwable ex) {
        String s;
        StringWriter strWriter = null;
        PrintWriter prtWriter = null;
        try {
            strWriter = new StringWriter();
            prtWriter = new PrintWriter(strWriter);
            LOGGER.error(prtWriter.toString());
            prtWriter.flush();
            s = strWriter.toString();
        }
        catch (Exception e) {
            LOGGER.error("", e);
            s = e.getMessage();
        }
        finally {
            if (strWriter != null) {
                try {
                    strWriter.close();
                }
                catch (Exception exception1) {
                    LOGGER.error("", exception1);
                    strWriter = null;
                }
            }
            if (prtWriter != null) {
                try {
                    prtWriter.close();
                }
                catch (Exception e) {
                    LOGGER.error("", e);
                    prtWriter = null;
                }
            }
        }
        return s;
    }
}

