/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import com.qianjiang.system.bean.OSSConf;
import com.qianjiang.system.service.OSSConfService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UploadImgLocal;
import com.qianjiang.util.UploadImgOSS;
import com.qianjiang.util.uploadutil.UploadImgCommon;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class UploadUtil
extends UploadImgCommon {
    private static final MyLogger LOGGER = new MyLogger(UploadUtil.class);
    private static final String LOGGERINFO1 = "\u7684\u56fe\u7247\u4e0d\u7b26\u5408\u9650\u5236";
    private static UploadImgLocal uploadImgLocal;
    private static UploadImgOSS uploadImgOSS;
    private static OSSConfService ossConfService;

    public OSSConfService getOssConfService() {
        return ossConfService;
    }

    @Resource(name="oSSConfServiceImpl")
    public void setOssConfService(OSSConfService ossConfService) {
        UploadUtil.ossConfService = ossConfService;
    }

    public UploadImgLocal getUploadImgLocal() {
        return uploadImgLocal;
    }

    @Autowired
    public void setUploadImgLocal(UploadImgLocal uploadImgLocal) {
        UploadUtil.uploadImgLocal = uploadImgLocal;
    }

    public UploadImgOSS getUploadImgOSS() {
        return uploadImgOSS;
    }

    @Autowired
    public void setUploadImgOSS(UploadImgOSS uploadImgOSS) {
        UploadUtil.uploadImgOSS = uploadImgOSS;
    }

    public OSSConfService getOssConfMapper() {
        return ossConfService;
    }

    @Autowired
    public void setOssConfMapper(OSSConfService ossConfService) {
        UploadUtil.ossConfService = ossConfService;
    }

    public static synchronized Map<String, String> uploadFile(MultipartFile muFile) {
        Map<String, String> map = null;
        try {
            OSSConf ossConf = ossConfService.findByOssStatus();
            if (muFile != null && muFile.getSize() > 0L && ossConf != null) {
                if (!UploadImgCommon.checkFileForSpringUpload(muFile)) {
                    throw new RuntimeException("\u4e0a\u4f20" + muFile.getOriginalFilename() + LOGGERINFO1);
                }
                String ossType = ossConf.getOssType();
                if ("0".equals(ossType)) {
                    map = uploadImgLocal.uploadForABCSize(muFile);
                } else if ("1".equals(ossType) || "2".equals(ossType)) {
                    map = uploadImgOSS.uploadForABCSize(muFile, ossConf);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25" + e.getMessage(), e);
        }
        return map;
    }

    public static synchronized String uploadFileOne(MultipartFile muFile, HttpServletRequest request) {
        return UploadUtil.uploadFileOne(muFile);
    }

    public static synchronized String uploadFileOne(MultipartFile muFile) {
        Map<String, String> map = null;
        try {
            OSSConf ossConf = ossConfService.findByOssStatus();
            if (muFile != null && muFile.getSize() > 0L && ossConf != null) {
                if (!UploadImgCommon.checkFileForSpringUpload(muFile)) {
                    throw new RuntimeException("\u4e0a\u4f20" + muFile.getOriginalFilename() + LOGGERINFO1);
                }
                String ossType = ossConf.getOssType();
                if ("0".equals(ossType)) {
                    map = uploadImgLocal.uploadForOldAndSmall(muFile);
                } else if ("1".equals(ossType) || "2".equals(ossType)) {
                    map = uploadImgOSS.uploadForOldAndSmall(muFile, ossConf);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25" + e.getMessage(), e);
        }
        return map == null ? null : (String)map.get("oldimg");
    }

    public static synchronized Map<String, String> uploadFileByWidth(MultipartFile muFile) {
        Map<String, String> map = null;
        try {
            OSSConf ossConf = ossConfService.findByOssStatus();
            if (muFile != null && muFile.getSize() > 0L && ossConf != null) {
                if (!UploadImgCommon.checkFileForSpringUpload(muFile)) {
                    throw new RuntimeException("\u4e0a\u4f20" + muFile.getOriginalFilename() + LOGGERINFO1);
                }
                String ossType = ossConf.getOssType();
                if ("0".equals(ossType)) {
                    map = uploadImgLocal.uploadForAllSize(muFile);
                } else if ("1".equals(ossType) || "2".equals(ossType)) {
                    map = uploadImgOSS.uploadForAllSize(muFile, ossConf);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25" + e.getMessage(), e);
        }
        return map;
    }

    public static synchronized String uploadFileOneByFile(FileItem item, HttpServletRequest req) {
        String result = null;
        try {
            OSSConf ossConf = ossConfService.findByOssStatus();
            if (item != null && item.getSize() > 0L && ossConf != null) {
                String dirName = req.getParameter("dir");
                if (dirName == null) {
                    dirName = "image";
                }
                LOGGER.info("\u4e0a\u4f20\u6587\u4ef6\u76ee\u5f55\u6807\u8bc6\u4e3a\uff1a" + dirName);
                if (!UploadImgCommon.checkFileAndMedia(item, dirName)) {
                    throw new RuntimeException("\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u7b26\u5408\u9650\u5236");
                }
                if ("image".equals(dirName)) {
                    String ossType = ossConf.getOssType();
                    if ("0".equals(ossType)) {
                        result = uploadImgLocal.uploadForRichEdit(item);
                    } else if ("1".equals(ossType) || "2".equals(ossType)) {
                        result = uploadImgOSS.uploadForRichEdit(item, ossConf);
                    }
                } else if ("media".equals(dirName)) {
                    result = uploadImgLocal.uploadForVideo(item);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25" + e.getMessage(), e);
        }
        return result;
    }
}

