/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.jcloud.jss.Credential;
import com.jcloud.jss.JingdongStorageService;
import com.jcloud.jss.domain.ObjectListing;
import com.jcloud.jss.domain.ObjectSummary;
import com.qianjiang.util.MyLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class OSSUtil {
    private static final MyLogger LOGGER = new MyLogger(OSSUtil.class);

    public static OSSClient getOSSClient(String endpoint, String accessKeyId, String accessKeySecret) {
        return new OSSClient(endpoint, accessKeyId, accessKeySecret);
    }

    public static String createBucketName(OSSClient ossClient, String bucketName) {
        String bucketNames = bucketName;
        if (!ossClient.doesBucketExist(bucketName)) {
            ossClient.createBucket(bucketName);
            LOGGER.info("\u521b\u5efa\u963f\u91cc\u4e91\u5b58\u50a8\u7a7a\u95f4\u6210\u529f\uff0cbuckName:" + bucketName);
            return bucketName;
        }
        return bucketNames;
    }

    public static String createFolder(OSSClient ossClient, String bucketName, String folder) {
        String keySuffixWithSlash = folder;
        if (!ossClient.doesObjectExist(bucketName, keySuffixWithSlash)) {
            ossClient.putObject(bucketName, keySuffixWithSlash, (InputStream)new ByteArrayInputStream(new byte[0]));
            OSSObject object = ossClient.getObject(bucketName, keySuffixWithSlash);
            String fileDir = object.getKey();
            LOGGER.info("\u521b\u5efa\u963f\u91cc\u4e91\u6587\u4ef6\u5939\u6210\u529f\uff0c\u6587\u4ef6\u5939\u540d:" + fileDir);
            return fileDir;
        }
        return keySuffixWithSlash;
    }

    public static String uploadFile2OSS(OSSClient ossClient, InputStream is, String bucketName, String folder, String fileName) {
        String resultStr = null;
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)is.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentEncoding("utf-8");
            objectMetadata.setContentType(OSSUtil.getContentType(fileName));
            objectMetadata.setContentDisposition("inline;filename=" + fileName);
            PutObjectResult putResult = ossClient.putObject(bucketName, folder + fileName, is, objectMetadata);
            resultStr = putResult.getETag();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u4e0a\u4f20\u963f\u91cc\u4e91OSS\u670d\u52a1\u5668\u5f02\u5e38");
        }
        return resultStr;
    }

    public static String uploadImg2Oss(OSSClient ossClient, File file, String bucketName, String folder) {
        try {
            FileInputStream is = new FileInputStream(file);
            String fileName = file.getName();
            String md5key = OSSUtil.uploadFile2OSS(ossClient, is, bucketName, folder, fileName);
            LOGGER.info("\u963f\u91cc\u4e91\u4e0a\u4f20\u540e\u7684\u6587\u4ef6MD5\u6570\u5b57\u552f\u4e00\u7b7e\u540d:" + md5key);
            return fileName;
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u963f\u91cc\u4e91\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
            return null;
        }
    }

    public static JingdongStorageService getJingdongStorageService(String endpoint, String accessKeyId, String accessKeySecret) {
        Credential credential = null;
        JingdongStorageService jss = null;
        try {
            credential = new Credential(accessKeyId, accessKeySecret);
            jss = new JingdongStorageService(credential);
            jss.setEndpoint(endpoint);
            LOGGER.info("\u83b7\u5f97\u4eac\u4e1c\u4e91oss\u5b58\u50a8\u670d\u52a1\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u83b7\u5f97\u4eac\u4e1c\u4e91oss\u5b58\u50a8\u670d\u52a1\u5931\u8d25" + e.getMessage(), e);
        }
        return jss;
    }

    public static String createBucketName(String endpoint, String accessKeyId, String accessKeySecret, String bucketName) {
        String bucketNames = bucketName;
        try {
            JingdongStorageService jss = OSSUtil.getJingdongStorageService(endpoint, accessKeyId, accessKeySecret);
            boolean have = jss.hasBucket(bucketName);
            if (!have) {
                jss.bucket(bucketName).create();
                LOGGER.info("\u4eac\u4e1c\u4e91\u521b\u5efabuckName\u6210\u529f\uff0cbuckName\uff1a" + bucketName);
                return bucketName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4eac\u4e1c\u4e91\u521b\u5efabuckName\u5931\u8d25" + e.getMessage(), e);
        }
        return bucketNames;
    }

    public static List<String> getAllKeyName(String endpoint, String accessKeyId, String accessKeySecret, String bucketName) {
        ArrayList<String> keyNames = new ArrayList<String>();
        try {
            JingdongStorageService jss = OSSUtil.getJingdongStorageService(endpoint, accessKeyId, accessKeySecret);
            ObjectListing objectList = jss.bucket(bucketName).listObject();
            for (ObjectSummary okey : objectList.getObjectSummaries()) {
                keyNames.add(okey.getKey());
                LOGGER.info("keyName:" + okey.getKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4eac\u4e1c\u4e91\u83b7\u5f97\u6307\u5b9a\u6587\u4ef6\u4e0b\u6240\u6709\u6587\u4ef6\u5931\u8d25" + e.getMessage(), e);
        }
        return keyNames;
    }

    public static String uploadJcloudImg2Oss(JingdongStorageService jss, File file, String bucketName, String folder) {
        String filePath = null;
        try {
            String fileName = file.getName();
            String md5key = jss.bucket(bucketName).object(folder + fileName).entity(file).contentType(OSSUtil.getContentType(fileName)).put();
            LOGGER.info("\u4eac\u4e1c\u4e91\u4e0a\u4f20\u540e\u7684\u6587\u4ef6MD5\u6570\u5b57\u552f\u4e00\u7b7e\u540d:" + md5key);
            URI uri = jss.bucket(bucketName).object(folder + fileName).generatePresignedUrl(999999999);
            filePath = uri.toURL().toString();
            LOGGER.info("\u6587\u4ef6\u8bbf\u95eeurl\uff1a" + filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4eac\u4e1c\u4e91\u4e0a\u4f20\u56fe\u7247\u81f3oss\u5931\u8d25" + e.getMessage(), e);
        }
        return filePath;
    }

    public static String getContentType(String fileName) {
        String fileExtension = fileName.substring(fileName.lastIndexOf("."));
        if (".bmp".equalsIgnoreCase(fileExtension)) {
            return "image/bmp";
        }
        if (".gif".equalsIgnoreCase(fileExtension)) {
            return "image/gif";
        }
        if (".jpeg".equalsIgnoreCase(fileExtension) || ".jpg".equalsIgnoreCase(fileExtension) || ".png".equalsIgnoreCase(fileExtension)) {
            return "image/jpeg";
        }
        if (".html".equalsIgnoreCase(fileExtension)) {
            return "text/html";
        }
        if (".txt".equalsIgnoreCase(fileExtension)) {
            return "text/plain";
        }
        if (".vsd".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.visio";
        }
        if (".ppt".equalsIgnoreCase(fileExtension) || "pptx".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.ms-powerpoint";
        }
        if (".doc".equalsIgnoreCase(fileExtension) || "docx".equalsIgnoreCase(fileExtension)) {
            return "application/msword";
        }
        if (".xml".equalsIgnoreCase(fileExtension)) {
            return "text/xml";
        }
        return "image/jpeg";
    }

    public static void main(String[] args) {
    }
}

