/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import com.aliyun.oss.OSSClient;
import com.jcloud.jss.JingdongStorageService;
import com.qianjiang.manager.service.SysHelperService;
import com.qianjiang.system.bean.OSSConf;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.OSSUtil;
import com.qianjiang.util.UploadImgCommon;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.fileupload.FileItem;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="uploadImgOSS")
public class UploadImgOSS {
    private static final MyLogger LOGGER = new MyLogger(UploadImgOSS.class);
    private static SysHelperService sysHelperService;

    public SysHelperService getSysHelperService() {
        return sysHelperService;
    }

    @Resource(name="SysHelperMapper")
    public void setSysHelperService(SysHelperService sysHelperService) {
        UploadImgOSS.sysHelperService = sysHelperService;
    }

    public Map<String, String> uploadForABCSize(MultipartFile muFile, OSSConf ossConf) {
        HashMap<String, String> imgMap = new HashMap<String, String>();
        String httpUrl = "";
        String folder = "";
        String fileNamess = UploadImgCommon.getPicNamePathSuffix();
        try {
            File file = new File(fileNamess);
            muFile.transferTo(file);
            String ossType = ossConf.getOssType();
            if ("1".equals(ossType)) {
                httpUrl = ossConf.getOssHttpurl().trim();
                folder = ossConf.getOssFolder().trim();
            } else if ("2".equals(ossType)) {
                httpUrl = ossConf.getJcloudHttpurl().trim();
                folder = ossConf.getJcloudFolder().trim();
            }
            this.uploadFromOss(ossConf, file, ossType);
            LOGGER.info("\u539f\u56fe\u5730\u5740\uff1a" + httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix);
            imgMap.put("oldimg", httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix);
            int[] widths = UploadImgCommon.getImgSetOut85(sysHelperService.selectImageSet());
            UploadImgCommon.sortWidth(widths);
            for (int i = 0; i < widths.length; ++i) {
                int mapKey = i;
                this.storeFileFromWidths(imgMap, httpUrl, folder, ossType, widths, i, mapKey);
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LOGGER.error("\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef", e);
        }
        return imgMap;
    }

    public Map<String, String> uploadForOldAndSmall(MultipartFile muFile, OSSConf ossConf) {
        HashMap<String, String> imgMap = new HashMap<String, String>();
        String httpUrl = "";
        String folder = "";
        String fileNamess = UploadImgCommon.getPicNamePathSuffix();
        try {
            File file = new File(fileNamess);
            muFile.transferTo(file);
            String ossType = ossConf.getOssType();
            if ("1".equals(ossType)) {
                httpUrl = ossConf.getOssHttpurl().trim();
                folder = ossConf.getOssFolder().trim();
            } else if ("2".equals(ossType)) {
                httpUrl = ossConf.getJcloudHttpurl().trim();
                folder = ossConf.getJcloudFolder().trim();
            }
            this.uploadFromOss(ossConf, file, ossType);
            LOGGER.info("\u539f\u56fe\u5730\u5740\uff1a" + httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix);
            imgMap.put("oldimg", httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix);
            int width = 56;
            int mapKey = 0;
            this.storeFileFromWidth(imgMap, httpUrl, folder, ossType, width, mapKey);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LOGGER.error("\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef", e);
        }
        return imgMap;
    }

    public Map<String, String> uploadForAllSize(MultipartFile muFile, OSSConf ossConf) {
        HashMap<String, String> imgMap = new HashMap<String, String>();
        String httpUrl = "";
        String folder = "";
        String fileNamess = UploadImgCommon.getPicNamePathSuffix();
        try {
            File file = new File(fileNamess);
            muFile.transferTo(file);
            String ossType = ossConf.getOssType();
            if ("1".equals(ossType)) {
                httpUrl = ossConf.getOssHttpurl().trim();
                folder = ossConf.getOssFolder().trim();
            } else if ("2".equals(ossType)) {
                httpUrl = ossConf.getJcloudHttpurl().trim();
                folder = ossConf.getJcloudFolder().trim();
            }
            this.uploadFromOss(ossConf, file, ossType);
            LOGGER.info("\u539f\u56fe\u5730\u5740\uff1a" + httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix);
            imgMap.put("oldimg", httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix);
            int[] widths = UploadImgCommon.getImgSet(sysHelperService.selectImageSet());
            UploadImgCommon.sortWidth(widths);
            for (int i = 0; i < widths.length; ++i) {
                int mapKey = widths[i];
                this.storeFileFromWidths(imgMap, httpUrl, folder, ossType, widths, i, mapKey);
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LOGGER.error("\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef", e);
        }
        return imgMap;
    }

    public String uploadForRichEdit(FileItem item, OSSConf ossConf) {
        String result = null;
        String httpUrl = "";
        String folder = "";
        String fileNamess = UploadImgCommon.getPicNamePathSuffix();
        try {
            File file = new File(fileNamess);
            item.write(file);
            String ossType = ossConf.getOssType();
            if ("1".equals(ossType)) {
                httpUrl = ossConf.getOssHttpurl().trim();
                folder = ossConf.getOssFolder().trim();
            } else if ("2".equals(ossType)) {
                httpUrl = ossConf.getJcloudHttpurl().trim();
                folder = ossConf.getJcloudFolder().trim();
            }
            this.uploadFromOss(ossConf, file, ossType);
            LOGGER.info("\u539f\u56fe\u5730\u5740\uff1a" + httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix);
            result = httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LOGGER.error("\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef", e);
        }
        return result;
    }

    private void uploadFromOss(OSSConf ossConf, File file, String ossType) {
        if ("1".equals(ossType)) {
            String endpoint = ossConf.getOssEndpoint().trim();
            String accessKeyId = ossConf.getOssAccesskeyId().trim();
            String accessKeySecret = ossConf.getOssAccesskeySecret().trim();
            String bucketName = ossConf.getOssBucketName().trim();
            String folder = ossConf.getOssFolder().trim();
            OSSClient ossClient = OSSUtil.getOSSClient(endpoint, accessKeyId, accessKeySecret);
            String filename = OSSUtil.uploadImg2Oss(ossClient, file, bucketName, folder);
            ossClient.shutdown();
        } else if ("2".equals(ossType)) {
            String jcloudEndpoint = ossConf.getJcloudEndpoint().trim();
            String jcloudAccesskeyId = ossConf.getJcloudAccesskeyId().trim();
            String jcloudAccesskeySecret = ossConf.getJcloudAccesskeySecret().trim();
            String jcloudBackName = ossConf.getJcloudBackName().trim();
            String jcloudFolder = ossConf.getJcloudFolder().trim();
            JingdongStorageService jss = OSSUtil.getJingdongStorageService(jcloudEndpoint, jcloudAccesskeyId, jcloudAccesskeySecret);
            String fileName = OSSUtil.uploadJcloudImg2Oss(jss, file, jcloudBackName, jcloudFolder);
        }
    }

    private void storeFileFromWidths(Map<String, String> imgMap, String httpUrl, String folder, String ossType, int[] widths, int i, int mapKey) {
        if ("1".equals(ossType)) {
            LOGGER.info("\u539f\u56fe\u5730\u5740\uff1a" + httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix + "?x-oss-process=image/resize,m_fixed,h_" + widths[i] + ",w_" + widths[i]);
            imgMap.put(mapKey + "", httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix + "?x-oss-process=image/resize,m_fixed,h_" + widths[i] + ",w_" + widths[i]);
        } else if ("2".equals(ossType)) {
            LOGGER.info("\u539f\u56fe\u5730\u5740\uff1a" + httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix + "?img/s/" + widths[i] + "/" + widths[i]);
            imgMap.put(mapKey + "", httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix + "?img/s/" + widths[i] + "/" + widths[i]);
        }
    }

    private void storeFileFromWidth(Map<String, String> imgMap, String httpUrl, String folder, String ossType, int width, int mapKey) {
        if ("1".equals(ossType)) {
            LOGGER.info("\u539f\u56fe\u5730\u5740\uff1a" + httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix + "?x-oss-process=image/resize,m_fixed,h_" + width + ",w_" + width);
            imgMap.put(mapKey + "", httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix + "?x-oss-process=image/resize,m_fixed,h_" + width + ",w_" + width);
        } else if ("2".equals(ossType)) {
            LOGGER.info("\u539f\u56fe\u5730\u5740\uff1a" + httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix + "?img/s/" + width + "/" + width);
            imgMap.put(mapKey + "", httpUrl + folder + UploadImgCommon.prefix + UploadImgCommon.suffix + "?img/s/" + width + "/" + width);
        }
    }
}

