/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.util.alipay.util;

import com.qianjiang.common.util.alipay.util.AlipayConfig;
import com.qianjiang.common.util.alipay.util.AlipayCore;
import com.qianjiang.common.util.alipay.util.MD5;
import com.qianjiang.common.util.alipay.util.httpClient.HttpProtocolHandler;
import com.qianjiang.common.util.alipay.util.httpClient.HttpRequest;
import com.qianjiang.common.util.alipay.util.httpClient.HttpResponse;
import com.qianjiang.common.util.alipay.util.httpClient.HttpResultType;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class AlipaySubmit {
    private static final String ALIPAY_GATEWAY_NEW = "https://mapi.alipay.com/gateway.do?";
    private static final String _INPUT_CHARSET = "_input_charset=";
    public static final MyLogger LOGGER = new MyLogger(AlipaySubmit.class);

    private AlipaySubmit() {
    }

    public static String buildRequestMysign(Map<String, String> sPara) {
        String prestr = AlipayCore.createLinkString(sPara);
        String mysign = "";
        if ("MD5".equals(AlipayConfig.sign_type)) {
            mysign = MD5.sign(prestr, AlipayConfig.key, AlipayConfig.input_charset);
        }
        return mysign;
    }

    private static Map<String, String> buildRequestPara(Map<String, String> sParaTemp) {
        Map<String, String> sPara = AlipayCore.paraFilter(sParaTemp);
        String mysign = AlipaySubmit.buildRequestMysign(sPara);
        sPara.put("sign", mysign);
        sPara.put("sign_type", AlipayConfig.sign_type);
        return sPara;
    }

    public static String buildRequest(Map<String, String> sParaTemp, String strMethod, String strButtonName) {
        Map<String, String> sPara = AlipaySubmit.buildRequestPara(sParaTemp);
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuilder sbHtml = new StringBuilder();
        sbHtml.append("<form id=\"alipaysubmit\" name=\"alipaysubmit\" action=\"https://mapi.alipay.com/gateway.do?_input_charset=" + AlipayConfig.input_charset + "\" method=\"" + strMethod + "\">");
        for (int i = 0; i < keys.size(); ++i) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sbHtml.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
        }
        sbHtml.append("<input type=\"submit\" value=\"" + strButtonName + "\" style=\"display:none;\"></form>");
        sbHtml.append("<script>document.forms['alipaysubmit'].submit();</script>");
        return sbHtml.toString();
    }

    public static String buildRequest(Map<String, String> sParaTemp, String strMethod, String strButtonName, String strParaFileName) {
        Map<String, String> sPara = AlipaySubmit.buildRequestPara(sParaTemp);
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuilder sbHtml = new StringBuilder();
        sbHtml.append("<form id=\"alipaysubmit\" name=\"alipaysubmit\"  enctype=\"multipart/form-data\" action=\"https://mapi.alipay.com/gateway.do?_input_charset=" + AlipayConfig.input_charset + "\" method=\"" + strMethod + "\">");
        for (int i = 0; i < keys.size(); ++i) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sbHtml.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
        }
        sbHtml.append("<input type=\"file\" name=\"" + strParaFileName + "\" />");
        sbHtml.append("<input type=\"submit\" value=\"" + strButtonName + "\" style=\"display:none;\"></form>");
        return sbHtml.toString();
    }

    public static String buildRequest(String strParaFileName, String strFilePath, Map<String, String> sParaTemp) throws Exception {
        Map<String, String> sPara = AlipaySubmit.buildRequestPara(sParaTemp);
        HttpProtocolHandler httpProtocolHandler = HttpProtocolHandler.getInstance();
        HttpRequest request = new HttpRequest(HttpResultType.BYTES);
        request.setCharset(AlipayConfig.input_charset);
        request.setParameters(AlipaySubmit.generatNameValuePair(sPara));
        request.setUrl("https://mapi.alipay.com/gateway.do?_input_charset=" + AlipayConfig.input_charset);
        HttpResponse response = httpProtocolHandler.execute(request, strParaFileName, strFilePath);
        if (response == null) {
            return null;
        }
        return response.getStringResult();
    }

    private static NameValuePair[] generatNameValuePair(Map<String, String> properties) {
        NameValuePair[] nameValuePair = new NameValuePair[properties.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            nameValuePair[i++] = new NameValuePair(entry.getKey(), entry.getValue());
        }
        return nameValuePair;
    }

    public static String query_timestamp() throws DocumentException {
        String strUrl = "https://mapi.alipay.com/gateway.do?service=query_timestamp&partner=" + AlipayConfig.partner + "&_input_charset" + AlipayConfig.input_charset;
        StringBuilder result = new StringBuilder();
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(new URL(strUrl).openStream());
        }
        catch (IOException e) {
            LOGGER.error("" + e);
            LOGGER.info("" + e);
        }
        List nodeList = doc.selectNodes("//alipay/*");
        for (Node node : nodeList) {
            if (!"is_success".equals(node.getName()) || !"T".equals(node.getText())) continue;
            List nodeList1 = doc.selectNodes("//response/timestamp/*");
            for (Node node1 : nodeList1) {
                result.append(node1.getText());
            }
        }
        return result.toString();
    }
}

