/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.logger.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public final class UtilDate {
    private static final Logger LOGGER = Logger.getLogger(UtilDate.class);
    private static final String DATE = "yyyy-MM-dd";

    private UtilDate() {
    }

    public static String dataFormat(Date date) {
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.UK);
        return time.format(date);
    }

    public static String todayFormat(Date date) {
        SimpleDateFormat time = new SimpleDateFormat(DATE);
        return time.format(date);
    }

    public static String todayFormatString(Date date) {
        SimpleDateFormat time = new SimpleDateFormat("yyyyMMdd");
        return time.format(date);
    }

    public static int todayFormatInt(Date date) {
        SimpleDateFormat time = new SimpleDateFormat("yyyyMMdd");
        return Integer.parseInt(time.format(date));
    }

    public static String yesterdayFormat(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return new SimpleDateFormat("yyyy-MM-dd ").format(cal.getTime());
    }

    public static String mathString(Date date) {
        SimpleDateFormat time = new SimpleDateFormat("yyyyMMddHHmmss", Locale.UK);
        return time.format(date);
    }

    public static Date stringToDate(String dateString) {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date time = null;
        try {
            time = formatDate.parse(dateString);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"String\u8f6cDate\u5931\u8d25\uff01", (Throwable)e);
        }
        return time;
    }

    public static Date stringToDateMM(String dateString) {
        SimpleDateFormat formatDate = new SimpleDateFormat(DATE);
        Date time = null;
        try {
            time = formatDate.parse(dateString);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"String\u8f6cDate\u5931\u8d25\uff01", (Throwable)e);
        }
        return time;
    }

    public static String nextNumberDate(int number) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        Date dd = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dd);
        calendar.add(5, number);
        return format.format(calendar.getTime());
    }

    public static String addDay(String s, int n) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE);
            Calendar cd = Calendar.getInstance();
            cd.setTime(sdf.parse(s));
            cd.add(5, n);
            return sdf.format(cd.getTime());
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static boolean compare_date(String nowDate, String endDate) {
        SimpleDateFormat df = new SimpleDateFormat(DATE);
        try {
            Date dt1 = df.parse(nowDate);
            Date dt2 = df.parse(endDate);
            if (dt1.getTime() <= dt2.getTime()) {
                return true;
            }
            if (dt1.getTime() > dt2.getTime()) {
                return false;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"\u65e5\u671f\u5bf9\u6bd4\u5931\u8d25\uff01", (Throwable)exception);
        }
        return false;
    }

    public static boolean compare_date_pv(Date nowDate, Date endDate) {
        try {
            Date dt1 = nowDate;
            Date dt2 = endDate;
            if (dt1.getTime() <= dt2.getTime()) {
                return false;
            }
            if (dt1.getTime() > dt2.getTime()) {
                return true;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"\u65e5\u671f\u5bf9\u6bd4\u5931\u8d25\uff01", (Throwable)exception);
        }
        return false;
    }

    public static int intervalSecondToNow(Date startDate) {
        long nowTime = new Date().getTime();
        long startTime = startDate.getTime();
        return (int)(nowTime - startTime) / 1000;
    }
}

