/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.logger.util;

import com.qianjiang.third.logger.bean.OperationLog;
import com.qianjiang.third.logger.util.UtilDate;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;

public final class ExportLog {
    private static final int WIDTH4000 = 4000;
    private static final int WIDTH6000 = 6000;
    private static final int WIDTH15000 = 15000;
    private static final int WIDTH3 = 3;
    private static final int WIDTH4 = 4;
    private static final int WIDTH5 = 5;
    private static final int WIDTH6 = 6;

    private ExportLog() {
    }

    public static void exportForLog(List<Object> loggerList, HttpServletResponse response) {
        ServletOutputStream ouputStream;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet hssfSheet = wb.createSheet("\u65e5\u5fd7\u5217\u8868");
        hssfSheet.setColumnWidth(0, 4000);
        hssfSheet.setColumnWidth(1, 6000);
        hssfSheet.setColumnWidth(2, 6000);
        hssfSheet.setColumnWidth(3, 6000);
        hssfSheet.setColumnWidth(4, 6000);
        hssfSheet.setColumnWidth(5, 15000);
        hssfSheet.createFreezePane(6, 2);
        HSSFRow row1 = hssfSheet.createRow(0);
        hssfSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        HSSFCell cell1 = row1.createCell(0);
        HSSFCellStyle cenStyle = wb.createCellStyle();
        cenStyle.setAlignment((short)2);
        cell1.setCellStyle((CellStyle)cenStyle);
        cell1.setCellValue("\u65e5\u5fd7\u5217\u8868");
        HSSFRow titleRow = hssfSheet.createRow(1);
        titleRow.createCell(0).setCellValue("\u65e5\u5fd7\u7f16\u53f7");
        titleRow.createCell(1).setCellValue("\u64cd\u4f5c\u4eba");
        titleRow.createCell(2).setCellValue("\u64cd\u4f5c\u4ebaIP");
        titleRow.createCell(3).setCellValue("\u64cd\u4f5c\u7c7b\u578b");
        titleRow.createCell(4).setCellValue("\u64cd\u4f5c\u65f6\u95f4");
        titleRow.createCell(5).setCellValue("\u64cd\u4f5c\u5185\u5bb9");
        if (null != loggerList && !loggerList.isEmpty()) {
            for (int i = 0; i < loggerList.size(); ++i) {
                OperationLog log = (OperationLog)loggerList.get(i);
                HSSFRow hssfRow = hssfSheet.createRow(2 + i);
                hssfRow.createCell(0).setCellValue((double)log.getOpId().longValue());
                hssfRow.createCell(1).setCellValue(log.getOpName());
                hssfRow.createCell(2).setCellValue(log.getOpIp());
                hssfRow.createCell(3).setCellValue(log.getOpCode());
                hssfRow.createCell(4).setCellValue(UtilDate.dataFormat(log.getOpTime()));
                hssfRow.createCell(5).setCellValue(log.getOpContent());
            }
        }
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            ouputStream = null;
        }
    }
}

