/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.OnLineServiceItem;
import com.qianjiang.system.controller.BaseController;
import com.qianjiang.system.service.IOnLineServiceItemBiz;
import com.qianjiang.util.MyLogger;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="onLineServiceItemController")
public class OnLineServiceItemController
extends BaseController {
    private static final MyLogger LOGGER = new MyLogger(OnLineServiceItemController.class);
    private static final String MSG = "msg";
    public static final String NAME = "name";
    private static final int MAX_ITEM = 20;
    public static final String OPERAPATH = "operaPath";
    @Resource(name="onLineServiceItemBizImpl")
    private IOnLineServiceItemBiz onLineServiceItemBizImpl;

    @RequestMapping(value={"/addOnLineServiceItem"})
    public ModelAndView addOnLineServiceItem(@Valid OnLineServiceItem onLineServiceItem, BindingResult bindingResult, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView("readOnLineService.htm?deleteStatus=0"));
        }
        try {
            onLineServiceItem.setOnlineSort(this.onLineServiceItemBizImpl.selectCountByOnLineService(onLineServiceItem.getOnLineServiceId()) + 1);
            onLineServiceItem.setInsertDate(new Date());
            Long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            onLineServiceItem.setInsertId(loginUserId.intValue());
            boolean flag = this.onLineServiceItemBizImpl.saveOnLineServiceItem(onLineServiceItem);
            if (flag) {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58\u5728\u7ebf\u5ba2\u670d\u9879\u6210\u529f\uff01");
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u5728\u7ebf\u5ba2\u670d\u9879", (String)(request.getSession().getAttribute(OPERAPATH) + ",\u6dfb\u52a0\u7528\u6237\u540d:" + customerName));
            } else {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58\u5728\u7ebf\u5ba2\u670d\u9879\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5728\u7ebf\u5ba2\u670d\u9879\u9519\u8bef\uff1a=>", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u5728\u7ebf\u5ba2\u670d\u9879\u5931\u8d25\uff01");
        }
        mav.setView((View)new RedirectView("readOnLineService.htm?deleteStatus=0"));
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/upItem"}, produces={"application/json;charset=UTF-8"})
    public boolean upItem(int id1, int id2) {
        try {
            return this.onLineServiceItemBizImpl.upItem(id1, id2);
        }
        catch (Exception e) {
            LOGGER.error("\u5ba2\u670d\u9879\u4e0a\u79fb\u5f02\u5e38\uff01", (Throwable)e);
            return false;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/downItem"}, produces={"application/json;charset=UTF-8"})
    public boolean downItem(int id1, int id2) {
        try {
            return this.onLineServiceItemBizImpl.downItem(id1, id2);
        }
        catch (Exception e) {
            LOGGER.error("\u5ba2\u670d\u9879\u4e0b\u79fb\u5f02\u5e38\uff01", (Throwable)e);
            return false;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/deleteOnLineServiceItem"}, produces={"application/json;charset=UTF-8"})
    public boolean deleteOnLineServiceItem(int id, HttpServletRequest request) {
        try {
            int n = this.onLineServiceItemBizImpl.delOnLineServiceItem(id);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u5728\u7ebf\u5ba2\u670d\u9879", (String)(request.getSession().getAttribute(OPERAPATH) + ",\u5220\u9664\u7528\u6237\u540d:" + customerName));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5728\u7ebf\u5ba2\u670d\u9879\u9519\u8bef\uff1a=>", (Throwable)e);
            return false;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/updateOnLineServiceItem"}, produces={"application/json;charset=UTF-8"})
    public boolean updateOnLineServiceItem(OnLineServiceItem item, HttpServletRequest request) {
        try {
            int n = this.onLineServiceItemBizImpl.updateOnLineServiceItem(item);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u5728\u7ebf\u5ba2\u670d\u9879", (String)(request.getSession().getAttribute(OPERAPATH) + ",\u4fee\u6539\u7528\u6237\u540d:" + customerName));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5728\u7ebf\u5ba2\u670d\u9879\u9519\u8bef\uff1a=>", (Throwable)e);
            return false;
        }
    }

    @RequestMapping(value={"/checkOnLineServiceItemNum"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkOnLineServiceItemNum(HttpServletRequest request, int onLineServiceId) {
        int onLineServiceItemCount = this.onLineServiceItemBizImpl.selectCountByOnLineService(onLineServiceId);
        return onLineServiceItemCount < 20;
    }
}

