/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.controller;

import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.information.bean.Information;
import com.qianjiang.information.bean.InformationType;
import com.qianjiang.information.service.InfoUserDefinedService;
import com.qianjiang.information.service.InformationService;
import com.qianjiang.information.service.InformationTypeService;
import com.qianjiang.information.vo.InformationVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.SelectBean;
import com.qianjiang.util.UploadUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class InformationController {
    private static final MyLogger LOGGER = new MyLogger(InformationController.class);
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String QUERYINFOVOLIST_HTM = "queryInfoVoList.htm?CSRFToken=";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="InformationService")
    private InformationService infoService;
    @Resource(name="InformationTypeService")
    private InformationTypeService infoTypeService;
    @Resource(name="InfoUserDefinedService")
    private InfoUserDefinedService infoUDService;
    @Resource(name="InfoImageManageService")
    private InfoImageManageService infoImageManageService;

    @RequestMapping(value={"/queryInfoVoList"})
    public ModelAndView queryInfoVoList(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean, Long typeId, String infoName) {
        LOGGER.debug("==============================\u67e5\u8be2\u6587\u7ae0\u5217\u8868==============================");
        if (!"".equals(infoName) && infoName != null) {
            selectBean.setSearchText(infoName);
        } else if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        request.setAttribute("selectBean", (Object)selectBean);
        List infoTypes = this.infoTypeService.selectInfoTypeByAttrForAddInfo();
        List infoUDs = this.infoUDService.findAllUserDefined();
        return new ModelAndView("jsp/information/information", "pageBean", (Object)this.infoService.queryByPageBean(pb, selectBean, typeId)).addObject("infoTypes", (Object)infoTypes).addObject("infoUDs", (Object)infoUDs);
    }

    @RequestMapping(value={"/showInformation"})
    public ModelAndView showInfo(HttpServletRequest request, HttpServletResponse response, Long infoId) {
        if (infoId != null) {
            LOGGER.debug("==============================\u67e5\u8be2\u6587\u7ae0\u5e76\u8df3\u8f6c\u5230\u67e5\u770b\u6216\u4fee\u6539\u9875\u9762==============================");
            Information info = this.infoService.selectByPrimaryKey(infoId);
            request.setAttribute("info", (Object)info);
            String userDefined = info.getUserDefined();
            if (null != userDefined) {
                request.setAttribute("userDefineds", (Object)userDefined.split(","));
            }
        }
        List infoUDs = this.infoUDService.findAllUserDefined();
        List infoTypes = this.infoTypeService.selectInfoTypeByAttrForAddInfo();
        return new ModelAndView("jsp/information/showInfo", "infoTypes", (Object)infoTypes).addObject("infoUDs", (Object)infoUDs);
    }

    @RequestMapping(value={"/showInformationajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Information showInfoajax(HttpServletRequest request, HttpServletResponse response, Long infoId) {
        Information info = null;
        if (infoId != null) {
            LOGGER.debug("==============================\u67e5\u8be2\u6587\u7ae0\u5e76\u8df3\u8f6c\u5230\u67e5\u770b\u6216\u4fee\u6539\u9875\u9762==============================");
            info = this.infoService.selectByPrimaryKey(infoId);
        }
        return info;
    }

    @RequestMapping(value={"/addInformation"})
    public ModelAndView addInfo(MultipartHttpServletRequest request, HttpServletResponse response, @Valid Information information, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFOVOLIST_HTM + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("==============================\u6dfb\u52a0\u6587\u7ae0==============================");
        try {
            InformationType currType;
            MultipartFile muFile = request.getFile("imageSrc");
            if (muFile != null && muFile.getSize() > 0L) {
                information.setImgSrc(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
                this.infoImageManageService.saveImage(information.getImgSrc());
            }
            if (!"2".equals((currType = this.infoTypeService.selectByPrimaryKey(information.getInfoTypeId())).getTemp3())) {
                information.setTemp3("0");
            } else {
                information.setTemp3("1");
            }
            information.setCreateUserId(Long.valueOf(1L));
            information.setIsThirdNews("0");
            this.infoService.saveInfo(information);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u6587\u7ae0", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("==============================\u6dfb\u52a0\u6587\u7ae0\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(QUERYINFOVOLIST_HTM + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateInformation"})
    public ModelAndView updateInfo(MultipartHttpServletRequest request, HttpServletResponse response, @Valid Information information, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFOVOLIST_HTM + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("==============================\u4fee\u6539\u6587\u7ae0==============================");
        try {
            InformationType currType;
            MultipartFile muFile = request.getFile("imageSrc");
            if (muFile != null && muFile.getSize() > 0L) {
                information.setImgSrc(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
                this.infoImageManageService.saveImage(information.getImgSrc());
            }
            if (!"2".equals((currType = this.infoTypeService.selectByPrimaryKey(information.getInfoTypeId())).getTemp3())) {
                information.setTemp3("0");
            } else {
                information.setTemp3("1");
            }
            information.setUpdateUserId(Long.valueOf(1L));
            this.infoService.updateInfo(information);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u6587\u7ae0", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("==============================\u4fee\u6539\u6587\u7ae0\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(QUERYINFOVOLIST_HTM + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/delInformation"})
    public void delInfo(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("==============================\u5220\u9664\u6587\u7ae0==============================");
        String[] ids = request.getParameterValues("infoIds[]");
        try {
            for (int i = 0; i < ids.length; ++i) {
                if ("on".equals(ids[i].toString())) continue;
                Long id = Long.valueOf(ids[i]);
                this.infoService.delInfo(id);
            }
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u6587\u7ae0", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (NumberFormatException e) {
            LOGGER.error("==============================\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @RequestMapping(value={"/checkInformationByTitle"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkInfoByTitle(String title, Long infoId) {
        LOGGER.debug("==============================\u9a8c\u8bc1\u6587\u7ae0\u662f\u5426\u5b58\u5728==============================");
        if (null != infoId) {
            return this.infoService.checkAddInfoByTitle(title, infoId);
        }
        return this.infoService.checkAddInfoByTitle(title);
    }

    @RequestMapping(value={"/selectByInfoType"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<InformationVo> selectByInfoType(HttpServletRequest req, HttpServletResponse resp, Long infoTypeId) {
        ArrayList<InformationVo> list = new ArrayList();
        try {
            list = this.infoService.selectByInfoType(infoTypeId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u680f\u76eeid\u67e5\u8be2\u6587\u7ae0\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

