/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.controller;

import com.qianjiang.mobile.bean.MobSinglepageMark;
import com.qianjiang.mobile.service.MobSinglepageMarkService;
import com.qianjiang.mobile.service.MobSinglepageService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class MobSinglepageMarkController {
    private static final MyLogger LOGGER = new MyLogger(MobSinglepageMarkController.class);
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String LOGINUSERID = "loginUserId";
    private static final String SHOWALLMOBMARKINFO_HTM = "showAllMobMarkInfo.htm?CSRFToken=";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d\uff1a";
    @Resource(name="MobSinglepageMarkService")
    private MobSinglepageMarkService mobSinglepageMarkService;
    @Resource(name="MobSinglepageService")
    private MobSinglepageService mobSinglepageService;

    @RequestMapping(value={"/showAllMobMarkInfo"})
    public ModelAndView showAllMobMarkInfo() {
        return new ModelAndView("jsp/mobile/mobSingleMark", "mobMarkList", (Object)this.mobSinglepageMarkService.queryAllMarkInfoByDel());
    }

    @RequestMapping(value={"/addMobMarkInfo"})
    public ModelAndView addMobMarkInfo(@Valid MobSinglepageMark mobSinglepageMark, HttpServletRequest request, HttpServletResponse response, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(SHOWALLMOBMARKINFO_HTM + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("========\u6dfb\u52a0\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e============");
        if (null != mobSinglepageMark.getName()) {
            LOGGER.info((Object)("\u6dfb\u52a0\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e\u4fe1\u606f,\u6dfb\u52a0\u7684\u6807\u7b7e\u540d\u79f0\u4e3a\uff1a" + mobSinglepageMark.getName()));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        try {
            mobSinglepageMark.setCreateUserId(loginUserId);
            this.mobSinglepageMarkService.insertSelective(mobSinglepageMark);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("============\u6dfb\u52a0\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(SHOWALLMOBMARKINFO_HTM + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateMobMarkInfo"})
    public ModelAndView updateMobMarkInfo(@Valid MobSinglepageMark mobSinglepageMark, HttpServletRequest request, HttpServletResponse response, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(SHOWALLMOBMARKINFO_HTM + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("========\u66f4\u65b0\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e============");
        if (null != mobSinglepageMark.getName()) {
            LOGGER.info((Object)("\u66f4\u65b0\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e\u4fe1\u606f,\u66f4\u65b0\u7684\u6807\u7b7e\u540d\u79f0\u4e3a\uff1a" + mobSinglepageMark.getName()));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        try {
            mobSinglepageMark.setUpdateUserId(loginUserId);
            this.mobSinglepageMarkService.updateMobMarkById(mobSinglepageMark);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u66f4\u65b0\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("============\u66f4\u65b0\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(SHOWALLMOBMARKINFO_HTM + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/deleteMobMarkInfo"})
    public ModelAndView deleteMobMarkInfo(HttpServletRequest request, HttpServletResponse response, Long markId) {
        LOGGER.debug("========\u5220\u9664\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e============");
        if (null != markId) {
            LOGGER.info((Object)("\u903b\u8f91\u5220\u9664\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e\u4fe1\u606f,\u5220\u9664\u7684\u6807\u7b7e\u540d\u79f0\u4e3a\uff1a" + this.mobSinglepageMarkService.selectMobMarkById(markId).getName()));
        }
        try {
            this.mobSinglepageMarkService.updateDelStatus(markId);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("============\u5220\u9664\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7e\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(SHOWALLMOBMARKINFO_HTM + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/checkDelExist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkDelExist(long markId) {
        return this.mobSinglepageService.queryCountByMarkId(Long.valueOf(markId)) <= 0;
    }

    @RequestMapping(value={"/checkNameExist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkNameExist(HttpServletRequest request, HttpServletResponse response) {
        String name = "";
        try {
            name = new String(request.getParameter(NAME).getBytes("ISO-8859-1"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u68c0\u9a8c\u79fb\u52a8\u7248\u5355\u9875\u6807\u7b7ename\u662f\u5426\u5df2\u5b58\u5728\uff0c\u8f6c\u7801\u5931\u8d25\uff01", (Throwable)e);
        }
        return this.mobSinglepageMarkService.checkNameExist(name) <= 0;
    }
}

