/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.customer.service.CustomerCommissionService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class CustomerCommissionController {
    private static final MyLogger LOGGER = new MyLogger(CustomerCommissionController.class);
    private static final String PAGEBEAN = "pageBean";
    @Resource(name="customerCommissionService")
    private CustomerCommissionService customerCommissionService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    private static final String REDIRECT = "customerCommission.htm";
    private static final String DATE = "yyyy-MM-dd HH:mm:ss";

    @RequestMapping(value={"/customerCommission"})
    public ModelAndView listCommission(PageBean pageBean, CustomerAllInfo allinfo) {
        ModelAndView mav = null;
        try {
            pageBean.setUrl(REDIRECT);
            pageBean = this.customerCommissionService.selectCommissionList(pageBean, allinfo);
            mav = new ModelAndView("jsp/customer/commissionlist", PAGEBEAN, (Object)pageBean);
        }
        catch (Exception e) {
            LOGGER.error("\u521d\u59cb\u5316\u4f1a\u5458\u4f63\u91d1\u5217\u8868\u5931\u8d25" + e.getMessage());
        }
        return mav;
    }

    @RequestMapping(value={"/queryCommission"})
    public ModelAndView queryCommission(Long customerId, PageBean pageBean) {
        ModelAndView mav = null;
        try {
            pageBean = this.customerCommissionService.selectCommissionDetail(customerId, pageBean);
            mav = new ModelAndView("jsp/customer/commissiondetail", PAGEBEAN, (Object)pageBean);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u4f1a\u5458\u4f63\u91d1\u660e\u7ec6\u5931\u8d25" + e.getMessage());
        }
        return mav;
    }

    @RequestMapping(value={"/delcommission"})
    public ModelAndView delcommission(Long commissionId) {
        try {
            this.customerCommissionService.delcommission(commissionId);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5355\u6761\u4f1a\u5458\u4f63\u91d1\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
        }
        return new ModelAndView((View)new RedirectView("queryCommission.htm"));
    }

    @RequestMapping(value={"/exportallcommission"})
    public void exportallCommission(HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("\u4f1a\u5458\u4f63\u91d1\u4fe1\u606f");
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        sheet.setColumnWidth(0, 6000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 6000);
        sheet.setColumnWidth(3, 6000);
        sheet.setColumnWidth(4, 6000);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u7528\u6237\u540d");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("\u7b49\u7ea7");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("\u624b\u673a");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("\u5df2\u8d5a\u4f63\u91d1");
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("\u521b\u5efa\u65f6\u95f4");
        cell.setCellStyle(style);
        List list = this.customerServiceMapper.selectAllCommission();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            row = sheet.createRow(i + 1);
            CustomerAllInfo info = (CustomerAllInfo)list.get(i);
            if (info.getCustomerUsername() != null) {
                row.createCell(0).setCellValue(info.getCustomerUsername());
            }
            if (info.getPointLevelName() != null) {
                row.createCell(1).setCellValue(info.getPointLevelName());
            }
            if (info.getInfoMobile() != null) {
                row.createCell(2).setCellValue(info.getInfoMobile());
            }
            if (info.getUserCommission() != null) {
                row.createCell(3).setCellValue(info.getUserCommission().toString());
            }
            if (info.getCreateTime() == null) continue;
            row.createCell(4).setCellValue(new SimpleDateFormat(DATE).format(info.getCreateTime()));
        }
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            wb.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51fa\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u539f\u56e0", (Throwable)e);
        }
    }

    @RequestMapping(value={"/exportCommissionCheck"})
    public void exportallCommission(HttpServletResponse response, Long[] customerIds) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("\u4f1a\u5458\u4f63\u91d1\u4fe1\u606f");
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        sheet.setColumnWidth(0, 6000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 6000);
        sheet.setColumnWidth(3, 6000);
        sheet.setColumnWidth(4, 6000);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u7528\u6237\u540d");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("\u7b49\u7ea7");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("\u624b\u673a");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("\u5df2\u8d5a\u4f63\u91d1");
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("\u521b\u5efa\u65f6\u95f4");
        cell.setCellStyle(style);
        List list = this.customerServiceMapper.selectCommissionByCustomerIds(customerIds);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            row = sheet.createRow(i + 1);
            CustomerAllInfo info = (CustomerAllInfo)list.get(i);
            if (info.getCustomerUsername() != null) {
                row.createCell(0).setCellValue(info.getCustomerUsername());
            }
            if (info.getPointLevelName() != null) {
                row.createCell(1).setCellValue(info.getPointLevelName());
            }
            if (info.getInfoMobile() != null) {
                row.createCell(2).setCellValue(info.getInfoMobile());
            }
            if (info.getUserCommission() != null) {
                row.createCell(3).setCellValue(info.getUserCommission().toString());
            }
            if (info.getCreateTime() == null) continue;
            row.createCell(4).setCellValue(new SimpleDateFormat(DATE).format(info.getCreateTime()));
        }
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            wb.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51fa\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u539f\u56e0", (Throwable)e);
        }
    }
}

