/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.controller;

import com.qianjiang.mobile.bean.MobHomePage;
import com.qianjiang.mobile.service.MobHomePageService;
import com.qianjiang.util.xml.XmlElementUtil;
import com.qianjiang.util.xml.XmlUtil;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.audio.mp3.MP3File;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Controller
public class MobHomeFullRollController {
    private static final Logger LOGGER = Logger.getLogger(MobHomeFullRollController.class);
    private static final String SETMOBHOMEPAGE_HTM = "setMobHomePage.htm";
    private static final String MUSIC = "music";
    private static final String MUSICNAME = "musicname";
    private static final String FULLROLL = "fullRoll";
    private static final String ROLL_A = "roll_a";
    XmlUtil xmlUtil = new XmlUtil();
    XmlElementUtil xmlElementUtil = new XmlElementUtil();
    static final Long STOREID = -1L;
    static final String xmlFilePath = "templete_mobile/xml/9gdemo.xml";
    static final String xslFilePath = "templete_mobile/xsl/9gdemo_save.xsl";
    static final String htmlFilePath = "templete_mobile/html/9gdemo.html";
    @Resource(name="MobHomePageService")
    private MobHomePageService mobHomePageService;

    @RequestMapping(value={"/saveFullRoll"})
    public ModelAndView saveFullRoll(Long merchantId, HttpServletRequest request) {
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u4fdd\u5b58\u5168\u5c4f\u8f6e\u64ad\u91cd\u590d\u63d0\u4ea4===========");
            return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        Element root = document.getDocumentElement();
        String fullRollId = request.getParameter("fullRollId");
        String sd = request.getParameter("sd");
        String music = request.getParameter(MUSIC);
        String musicname = request.getParameter(MUSICNAME);
        String[] src = request.getParameterValues("fullRollImgSrc");
        String[] href = request.getParameterValues("fullRollHref");
        if (null != fullRollId && !"".equals(fullRollId)) {
            this.updateAdvElement(root, fullRollId, sd, music, musicname, src, href);
        } else {
            this.createAdvElement(root, sd, music, musicname, src, href);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
    }

    private void createAdvElement(Element root, String sd, String music, String musicname, String[] src, String[] href) {
        Element[] fullRolls = this.xmlElementUtil.getElementsByName(root, FULLROLL);
        int max = 0;
        for (Element el : fullRolls) {
            int temp = Integer.valueOf(el.getAttribute("id"));
            if (temp <= max) continue;
            max = temp;
        }
        Element newFullRoll = root.getOwnerDocument().createElement(FULLROLL);
        this.xmlElementUtil.setElementAttr(newFullRoll, "id", String.valueOf(max + 1));
        this.xmlElementUtil.setElementAttr(newFullRoll, "sd", sd);
        this.xmlElementUtil.setElementAttr(newFullRoll, MUSIC, music);
        this.xmlElementUtil.setElementAttr(newFullRoll, MUSICNAME, musicname);
        root.appendChild(newFullRoll);
        for (int i = 0; i < src.length; ++i) {
            Element newA = newFullRoll.getOwnerDocument().createElement(ROLL_A);
            this.xmlElementUtil.setElementAttr(newA, "href", href[i]);
            Element newImg = newA.getOwnerDocument().createElement("img");
            this.xmlElementUtil.setElementAttr(newImg, "src", src[i]);
            this.xmlElementUtil.setElementAttr(newImg, "widthB", "100%");
            this.xmlElementUtil.setElementAttr(newImg, "heightB", "100%");
            newA.appendChild(newImg);
            newFullRoll.appendChild(newA);
        }
    }

    private void updateAdvElement(Element root, String fullRollId, String sd, String music, String musicname, String[] src, String[] href) {
        Element[] fullRolls;
        Element oldFullRoll = null;
        for (Element el : fullRolls = this.xmlElementUtil.getElementsByName(root, FULLROLL)) {
            Element[] as;
            if (!el.getAttribute("id").equals(fullRollId)) continue;
            oldFullRoll = el;
            for (Element a : as = this.xmlElementUtil.getElementsByName(el, ROLL_A)) {
                el.removeChild(a);
            }
        }
        this.xmlElementUtil.setElementAttr(oldFullRoll, "sd", sd);
        this.xmlElementUtil.setElementAttr(oldFullRoll, MUSIC, music);
        this.xmlElementUtil.setElementAttr(oldFullRoll, MUSICNAME, musicname);
        for (int i = 0; i < src.length; ++i) {
            Element newA = oldFullRoll.getOwnerDocument().createElement(ROLL_A);
            this.xmlElementUtil.setElementAttr(newA, "href", href[i]);
            Element newImg = newA.getOwnerDocument().createElement("img");
            this.xmlElementUtil.setElementAttr(newImg, "src", src[i]);
            this.xmlElementUtil.setElementAttr(newImg, "widthB", "100%");
            this.xmlElementUtil.setElementAttr(newImg, "heightB", "100%");
            newA.appendChild(newImg);
            oldFullRoll.appendChild(newA);
        }
    }

    @RequestMapping(value={"/deleteFullRoll"})
    public ModelAndView deleteFullRoll(Long merchantId, HttpServletRequest request) {
        Element[] fullRolls;
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u5220\u9664\u5168\u5c4f\u8f6e\u64ad\u91cd\u590d\u63d0\u4ea4===========");
            return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        String id = request.getParameter("id");
        Element root = document.getDocumentElement();
        for (Element el : fullRolls = this.xmlElementUtil.getElementsByName(root, FULLROLL)) {
            if (!this.xmlElementUtil.getElementAttr(el, "id").equals(id)) continue;
            root.removeChild(el);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
    }

    @RequestMapping(value={"/clearAll"})
    public void clearAll(Long merchantId, HttpServletRequest request) {
        Element[] els;
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        Element root = document.getDocumentElement();
        this.xmlElementUtil.getElements(root);
        for (Element el : els = this.xmlElementUtil.getElements(root)) {
            root.removeChild(el);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
    }

    @RequestMapping(value={"/searchMp3"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Map<String, String>> searchMp3(HttpServletRequest request) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        String rootPath = request.getContextPath();
        String root = request.getSession().getServletContext().getRealPath("/");
        Path dir = Paths.get(root + "templete_mobile", new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "*.mp3");){
            for (Path path : stream) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("mp3name", path.getFileName().toString());
                map.put("mp3address", rootPath + "/templete_mobile/" + path.getFileName().toString());
                Long fileLength = path.toFile().length() / 1024L;
                map.put("mp3length", String.valueOf(fileLength));
                MP3File f = (MP3File)AudioFileIO.read((File)path.toFile());
                MP3AudioHeader audioHeader = (MP3AudioHeader)f.getAudioHeader();
                map.put("mp3time", audioHeader.getTrackLengthAsString());
                list.add(map);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return list;
    }

    private String mkToken() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }

    private String mkRSV() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }
}

