/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.controller;

import com.qianjiang.mobile.bean.MobHomePage;
import com.qianjiang.mobile.service.MobHomePageService;
import com.qianjiang.util.xml.XmlElementUtil;
import com.qianjiang.util.xml.XmlUtil;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Controller
public class MobHomeMountingsController {
    private static final Logger LOGGER = Logger.getLogger(MobHomeMountingsController.class);
    private static final String SETMOBHOMEPAGE_HTM = "setMobHomePage.htm";
    private static final String BLANKBOX = "blankbox";
    private static final String DIVIDING = "dividing";
    XmlUtil xmlUtil = new XmlUtil();
    XmlElementUtil xmlElementUtil = new XmlElementUtil();
    static final String xmlFilePath = "templete_mobile/xml/9gdemo.xml";
    @Resource(name="MobHomePageService")
    private MobHomePageService mobHomePageService;

    @RequestMapping(value={"/saveBlankbox"})
    public ModelAndView saveBlankbox(Long merchantId, HttpServletRequest request) {
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u4fdd\u5b58\u7a7a\u767d\u5360\u4f4d\u91cd\u590d\u63d0\u4ea4===========");
            return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        Element root = document.getDocumentElement();
        String blankBoxId = request.getParameter("blankBoxId");
        String height = request.getParameter("height");
        if (null != blankBoxId && !"".equals(blankBoxId)) {
            this.updateBlankboxElement(root, blankBoxId, height);
        } else {
            this.createBlankboxElement(root, height);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
    }

    private void createBlankboxElement(Element root, String height) {
        Element[] blankboxs = this.xmlElementUtil.getElementsByName(root, BLANKBOX);
        int max = 0;
        for (Element el : blankboxs) {
            int temp = Integer.valueOf(el.getAttribute("id"));
            if (temp <= max) continue;
            max = temp;
        }
        Element newBlankbox = root.getOwnerDocument().createElement(BLANKBOX);
        this.xmlElementUtil.setElementAttr(newBlankbox, "id", String.valueOf(max + 1));
        this.xmlElementUtil.setElementAttr(newBlankbox, "height", height);
        root.appendChild(newBlankbox);
    }

    private void updateBlankboxElement(Element root, String blankBoxId, String height) {
        Element[] blankboxs;
        Element oldBlankbox = null;
        for (Element el : blankboxs = this.xmlElementUtil.getElementsByName(root, BLANKBOX)) {
            if (!el.getAttribute("id").equals(blankBoxId)) continue;
            oldBlankbox = el;
        }
        this.xmlElementUtil.setElementAttr(oldBlankbox, "height", height);
    }

    @RequestMapping(value={"/deleteBlankbox"})
    public ModelAndView deleteBlankbox(Long merchantId, HttpServletRequest request) {
        Element[] blankboxs;
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u5220\u9664\u7a7a\u767d\u5360\u4f4d\u91cd\u590d\u63d0\u4ea4===========");
            return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        String id = request.getParameter("id");
        Element root = document.getDocumentElement();
        for (Element el : blankboxs = this.xmlElementUtil.getElementsByName(root, BLANKBOX)) {
            if (!this.xmlElementUtil.getElementAttr(el, "id").equals(id)) continue;
            root.removeChild(el);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
    }

    @ResponseBody
    @RequestMapping(value={"/addLine"}, produces={"application/json;charset=UTF-8"})
    public void addLine(Long merchantId, HttpServletRequest request) {
        request.getSession().setAttribute("reload", (Object)1);
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        Element root = document.getDocumentElement();
        Element[] lineApps = this.xmlElementUtil.getElementsByName(root, DIVIDING);
        int max = 0;
        for (Element el : lineApps) {
            int temp = Integer.valueOf(el.getAttribute("id"));
            if (temp <= max) continue;
            max = temp;
        }
        Element newBlankbox = root.getOwnerDocument().createElement(DIVIDING);
        this.xmlElementUtil.setElementAttr(newBlankbox, "id", String.valueOf(max + 1));
        root.appendChild(newBlankbox);
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
    }

    @RequestMapping(value={"/deleteLine"})
    public ModelAndView deleteLine(Long merchantId, HttpServletRequest request) {
        Element[] blankboxs;
        request.getSession().setAttribute("reload", (Object)1);
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u5220\u9664\u5206\u9694\u7ebf\u91cd\u590d\u63d0\u4ea4===========");
            return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        String id = request.getParameter("id");
        Element root = document.getDocumentElement();
        for (Element el : blankboxs = this.xmlElementUtil.getElementsByName(root, DIVIDING)) {
            if (!this.xmlElementUtil.getElementAttr(el, "id").equals(id)) continue;
            root.removeChild(el);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
    }

    private String mkToken() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }

    private String mkRSV() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }
}

