/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.bean.WareHouse;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.goods.vo.WareHouseVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class WareController {
    private static final MyLogger LOGGER = new MyLogger(WareController.class);
    private static final String LOGGERINFO1 = "-->\u4ed3\u5e93\u540d\u79f0\u3010";
    private static final String LOGGERINFO2 = "\u3011,\u7528\u6237\u540d\uff1a";
    private WareHouseService wareHouseService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryWareHouseByPageBean"})
    public ModelAndView queryWareHouseByPageBean(PageBean pb, SelectBean selectBean) {
        LOGGER.info((Object)"\u5206\u9875\u67e5\u8be2\u4ed3\u5e93\u4fe1\u606f");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("selectBean", selectBean);
            map.put("pb", this.wareHouseService.queryAllWareHouseByPageBean(pb, selectBean));
            ModelAndView modelAndView = new ModelAndView("jsp/wareHouse/ware_house", "map", map);
            return modelAndView;
        }
        finally {
            map = null;
        }
    }

    @RequestMapping(value={"/saveWareHouse"})
    public ModelAndView saveWareHouse(@Valid WareHouse wareHouse, HttpServletRequest request, Long[] districtIds) {
        if (wareHouse.getWareAdmin() == null) {
            wareHouse.setWareAdmin((Long)request.getSession().getAttribute("loginUserId"));
        }
        if (null != wareHouse.getWareName() && "".equals(wareHouse.getWareName())) {
            LOGGER.info((Object)("\u4fdd\u5b58\u4ed3\u5e93\u4fe1\u606f,\u4fdd\u5b58\u7684\u4ed3\u5e93\u540d\u79f0\u4e3a\uff1a" + wareHouse.getWareName()));
        } else {
            LOGGER.info((Object)"\u4fdd\u5b58\u4ed3\u5e93\u4fe1\u606f");
        }
        this.wareHouseService.saveWareHouse(wareHouse, (String)request.getSession().getAttribute("name"), districtIds);
        OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)((String)request.getSession().getAttribute("name")), (String)"\u4fdd\u5b58\u4ed3\u5e93\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + wareHouse.getWareName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("queryWareHouseByPageBean.htm"));
    }

    @RequestMapping(value={"/delWareHouse"})
    public ModelAndView delWareHouse(Long wareId, HttpServletRequest request) {
        WareHouseVo wareHouseVos = this.wareHouseService.selectWareByWareId(wareId);
        LOGGER.info((Object)"\u5220\u9664\u4ed3\u5e93\u4fe1\u606f");
        this.wareHouseService.deleteWareById(wareId, (String)request.getSession().getAttribute("name"));
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u4ed3\u5e93\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + wareHouseVos.getWareName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("queryWareHouseByPageBean.htm"));
    }

    @RequestMapping(value={"/batchDelWare"})
    public ModelAndView batchDelWareHouse(Long[] tagCheck, HttpServletRequest request) {
        LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u4ed3\u5e93\u4fe1\u606f");
        this.wareHouseService.batchDelWare(tagCheck, (String)request.getSession().getAttribute("name"));
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u4ed3\u5e93\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("queryWareHouseByPageBean.htm"));
    }

    @RequestMapping(value={"/updateWareHouse"})
    public ModelAndView updateWareHouse(@Valid WareHouse wareHouse, HttpServletRequest request, Long[] districtIds) {
        LOGGER.info((Object)("\u66f4\u65b0\u4ed3\u5e93\u4fe1\u606f\u9700\u8981\u66f4\u65b0\u7684\u4ed3\u5e93\u540d\u79f0\u4e3a:" + wareHouse.getWareName()));
        this.wareHouseService.updateWareHouse(wareHouse, (String)request.getSession().getAttribute("name"), districtIds);
        OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u4ed3\u5e93\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + wareHouse.getWareName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("queryWareHouseByPageBean.htm"));
    }

    public WareHouseService getWareHouseService() {
        return this.wareHouseService;
    }

    @Resource(name="WareHouseService")
    public void setWareHouseService(WareHouseService wareHouseService) {
        this.wareHouseService = wareHouseService;
    }
}

