/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.temp.controller;

import com.qianjiang.channel.bean.Channel;
import com.qianjiang.channel.service.GoodsCateService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.ClassifyBar;
import com.qianjiang.temp.bean.ClassifyBarCate;
import com.qianjiang.temp.bean.ClassifyBarQuick;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.ClassifyBarCateService;
import com.qianjiang.temp.service.ClassifyBarQuickService;
import com.qianjiang.temp.service.ClassifyBarService;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class TempClassifyBarController {
    private static final String CLASSIFYBAR = "classifyBar";
    private static final String ISTOP = "isTop";
    private static final String CATELIST = "cateList";
    private static final String TEMPID = "tempId";
    private static final String CHANNELID = "channelId";
    private static final String PARENTID = "parentId";
    private static final String ISDEFIND = "isDefind";
    private static final String JUMPFORCLASSIFYBARVIEW1 = "jumpForClassifyBarView.htm?tempId=";
    private static final String JUMPFORCLASSIFYBARVIEW2 = "jumpForClassifyBarView.htm?channelId=";
    private static final String IMGSRC = "imgSrc";
    private static final String INFO1 = "\u6dfb\u52a0\u5206\u7c7b\u5bfc\u822a";
    private static final String INFO2 = ",\u7528\u6237\u540d:";
    private static final String INFO3 = "\u4fee\u6539\u5206\u7c7b\u5bfc\u822a";
    private TempService tempService;
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    private ClassifyBarService classifyBarService;
    private GoodsCateService goodsCateService;
    @Resource(name="ClassifyBarCateService")
    private ClassifyBarCateService barCateService;
    @Resource(name="ClassifyBarQuickService")
    private ClassifyBarQuickService barQuickService;
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final MyLogger LOGGER = new MyLogger(TempClassifyBarController.class);

    @RequestMapping(value={"/jumpForClassifyBarView"})
    public ModelAndView jumpForClassifyBarView(Long tempId, Long channelId) {
        ModelAndView mav = new ModelAndView();
        if (null == channelId) {
            SysTemp temp = this.tempService.getSystempById(tempId);
            mav.addObject("temp", (Object)temp);
        } else {
            Channel channel = this.channelService.findChannelByID(channelId);
            mav.addObject("channel", (Object)channel);
        }
        mav.setViewName("jsp/temp/temp_classifyBar_list");
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/queryTempClassifyBar"}, produces={"application/json;charset=UTF-8"})
    public PageBean queryTempClassifyBar(PageBean pb, Long tempId, Long channelId) {
        return this.classifyBarService.selectClassifyBarByParam(pb, tempId, channelId, null);
    }

    @RequestMapping(value={"/showTempClassifyBar"})
    public ModelAndView showTempClassifyBar(Long classifyBarId, Long tempId, Long channelId, Long parentId) {
        Long parentIdNew = parentId;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List cateList = null;
        if (null != classifyBarId) {
            ClassifyBar classifyBar = this.classifyBarService.getClassifyBarById(classifyBarId);
            map.put(CLASSIFYBAR, classifyBar);
            if (null != classifyBar.getParentId() && classifyBar.getParentId() > 0L) {
                Long parentIdCate = this.classifyBarService.getClassifyBarById(classifyBar.getParentId()).getGoodsCatId();
                cateList = this.goodsCateService.queryGoosCateByParentId(parentIdCate);
                parentIdNew = classifyBar.getParentId();
            } else if (null != channelId) {
                Channel channel = this.channelService.findChannelByID(channelId);
                cateList = this.goodsCateService.queryGoosCateByParentId(channel.getGoodsCatId());
            } else {
                map.put(ISTOP, 1);
                cateList = this.goodsCateService.queryAllFirstGradeGoosCate();
            }
        } else if (null != parentIdNew) {
            Long parentIdCate = this.classifyBarService.getClassifyBarById(parentIdNew).getGoodsCatId();
            cateList = this.goodsCateService.queryGoosCateByParentId(parentIdCate);
        } else if (null != channelId) {
            Channel channel = this.channelService.findChannelByID(channelId);
            cateList = this.goodsCateService.queryGoosCateByParentId(channel.getGoodsCatId());
        } else {
            map.put(ISTOP, 1);
            cateList = this.goodsCateService.queryAllFirstGradeGoosCate();
        }
        map.put(CATELIST, cateList);
        map.put(TEMPID, tempId);
        map.put(CHANNELID, channelId);
        map.put(PARENTID, parentIdNew);
        return new ModelAndView("jsp/temp/show_temp_classifyBar", "map", map);
    }

    @RequestMapping(value={"/showtempclassifybarajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> showTempClassifyBarAjax(Long classifyBarId, Long tempId, Long channelId, Long parentId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List cateList = null;
        if (null != classifyBarId) {
            ClassifyBar classifyBar = this.classifyBarService.getClassifyBarById(classifyBarId);
            map.put(CLASSIFYBAR, classifyBar);
            if (null != classifyBar.getParentId() && classifyBar.getParentId() > 0L) {
                Long parentIdCate = this.classifyBarService.getClassifyBarById(classifyBar.getParentId()).getGoodsCatId();
                cateList = this.goodsCateService.queryGoosCateByParentId(parentIdCate);
                parentId = classifyBar.getParentId();
            } else if (null != channelId) {
                Channel channel = this.channelService.findChannelByID(channelId);
                cateList = this.goodsCateService.queryGoosCateByParentId(channel.getGoodsCatId());
            } else {
                map.put(ISTOP, 1);
                cateList = this.goodsCateService.queryAllFirstGradeGoosCate();
            }
        } else if (null != parentId) {
            Long parentIdCate = this.classifyBarService.getClassifyBarById(parentId).getGoodsCatId();
            cateList = this.goodsCateService.queryGoosCateByParentId(parentIdCate);
        } else if (null != channelId) {
            Channel channel = this.channelService.findChannelByID(channelId);
            cateList = this.goodsCateService.queryGoosCateByParentId(channel.getGoodsCatId());
        } else {
            map.put(ISTOP, 1);
            cateList = this.goodsCateService.queryAllFirstGradeGoosCate();
        }
        map.put(CATELIST, cateList);
        map.put(TEMPID, tempId);
        map.put(CHANNELID, channelId);
        map.put(PARENTID, parentId);
        return map;
    }

    @RequestMapping(value={"/showTempClassifyBarAndCateAndQuick"})
    public ModelAndView showTempClassifyBarAndCateAndQuick(Long classifyBarId, Long tempId, Long channelId, Long parentId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List cateList = new ArrayList();
        if (null != classifyBarId) {
            ClassifyBar classifyBar = this.classifyBarService.getClassifyBarById(classifyBarId);
            map.put(CLASSIFYBAR, classifyBar);
            if (null != classifyBar.getParentId() && classifyBar.getParentId() > 0L) {
                ClassifyBar parent = this.classifyBarService.getClassifyBarById(classifyBar.getParentId());
                if (parent.getGoodsCatId() == -1L) {
                    map.put(ISDEFIND, 1);
                } else if (parent.getGrade() > 1 || null != channelId) {
                    cateList = this.goodsCateService.queryGoosCateByParentId(parent.getGoodsCatId());
                } else {
                    List list = this.barCateService.selectByClassifyBarId(parent.getClassifyBarId());
                    for (ClassifyBarCate barCate : list) {
                        cateList.addAll(this.goodsCateService.queryGoosCateByParentId(barCate.getCateId()));
                    }
                }
                parentId = classifyBar.getParentId();
            } else if (null != channelId) {
                Channel channel = this.channelService.findChannelByID(channelId);
                cateList = this.goodsCateService.queryGoosCateByParentId(channel.getGoodsCatId());
            } else {
                map.put(ISTOP, 1);
                cateList = this.goodsCateService.queryAllFirstGradeGoosCate();
                map.put("barCates", this.barCateService.selectByClassifyBarId(classifyBarId));
                map.put("barQuicks", this.barQuickService.selectByClassifyBarId(classifyBarId));
            }
        } else if (null != parentId) {
            ClassifyBar parent = this.classifyBarService.getClassifyBarById(parentId);
            if (parent.getGoodsCatId() == -1L) {
                map.put(ISDEFIND, 1);
            } else if (parent.getGrade() > 1 || null != channelId) {
                cateList = this.goodsCateService.queryGoosCateByParentId(parent.getGoodsCatId());
            } else {
                List list = this.barCateService.selectByClassifyBarId(parent.getClassifyBarId());
                for (ClassifyBarCate barCate : list) {
                    cateList.addAll(this.goodsCateService.queryGoosCateByParentId(barCate.getCateId()));
                }
            }
        } else if (null != channelId) {
            Channel channel = this.channelService.findChannelByID(channelId);
            cateList = this.goodsCateService.queryGoosCateByParentId(channel.getGoodsCatId());
        } else {
            map.put(ISTOP, 1);
            cateList = this.goodsCateService.queryAllFirstGradeGoosCate();
        }
        map.put(CATELIST, cateList);
        map.put(TEMPID, tempId);
        map.put(CHANNELID, channelId);
        map.put(PARENTID, parentId);
        return new ModelAndView("jsp/temp/show_temp_classifyBar", "map", map);
    }

    @RequestMapping(value={"/showtempclassifybarandcateandquickajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> showTempClassifyBarAndCateAndQuickAjax(Long classifyBarId, Long channelId, Long parentId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List cateList = new ArrayList();
        if (null != classifyBarId) {
            ClassifyBar classifyBar = this.classifyBarService.getClassifyBarById(classifyBarId);
            map.put(CLASSIFYBAR, classifyBar);
            if (null != classifyBar.getParentId() && classifyBar.getParentId() > 0L) {
                ClassifyBar parent = this.classifyBarService.getClassifyBarById(classifyBar.getParentId());
                if (parent.getGoodsCatId() == -1L) {
                    map.put(ISDEFIND, 1);
                } else if (parent.getGrade() > 1 || null != channelId) {
                    cateList = this.goodsCateService.queryGoosCateByParentId(parent.getGoodsCatId());
                } else {
                    List list = this.barCateService.selectByClassifyBarId(parent.getClassifyBarId());
                    for (ClassifyBarCate barCate : list) {
                        cateList.addAll(this.goodsCateService.queryGoosCateByParentId(barCate.getCateId()));
                    }
                }
                parentId = classifyBar.getParentId();
            } else if (null != channelId) {
                Channel channel = this.channelService.findChannelByID(channelId);
                cateList = this.goodsCateService.queryGoosCateByParentId(channel.getGoodsCatId());
            } else {
                map.put(ISTOP, 1);
                cateList = this.goodsCateService.queryAllFirstGradeGoosCate();
                map.put("barCates", this.barCateService.selectByClassifyBarId(classifyBarId));
                map.put("barQuicks", this.barQuickService.selectByClassifyBarId(classifyBarId));
            }
        } else if (null != parentId) {
            ClassifyBar parent = this.classifyBarService.getClassifyBarById(parentId);
            if (parent.getGoodsCatId() == -1L) {
                map.put(ISDEFIND, 1);
            } else if (parent.getGrade() > 1 || null != channelId) {
                cateList = this.goodsCateService.queryGoosCateByParentId(parent.getGoodsCatId());
            } else {
                List list = this.barCateService.selectByClassifyBarId(parent.getClassifyBarId());
                for (ClassifyBarCate barCate : list) {
                    if (barCate.getCateId() == 0L) continue;
                    cateList.addAll(this.goodsCateService.queryGoosCateByParentId(barCate.getCateId()));
                }
            }
        } else if (null != channelId) {
            Channel channel = this.channelService.findChannelByID(channelId);
            cateList = this.goodsCateService.queryGoosCateByParentId(channel.getGoodsCatId());
        } else {
            map.put(ISTOP, 1);
            cateList = this.goodsCateService.queryAllFirstGradeGoosCate();
        }
        map.put(CATELIST, cateList);
        return map;
    }

    @RequestMapping(value={"/createTempClassifyBar"})
    public ModelAndView createTempClassifyBar(MultipartHttpServletRequest request, @Valid ClassifyBar classifyBar, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            if (null == classifyBar.getChannelId()) {
                return new ModelAndView((View)new RedirectView(JUMPFORCLASSIFYBARVIEW1 + classifyBar.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
            }
            return new ModelAndView((View)new RedirectView(JUMPFORCLASSIFYBARVIEW2 + classifyBar.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        if (null == classifyBar.getParentId()) {
            classifyBar.setGrade(Integer.valueOf(1));
        } else {
            classifyBar.setGrade(Integer.valueOf(this.classifyBarService.getClassifyBarById(classifyBar.getParentId()).getGrade() + 1));
        }
        MultipartFile muFile = request.getFile(IMGSRC);
        if (null != muFile && muFile.getSize() > 0L) {
            classifyBar.setTemp2(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
        }
        classifyBar.setCreateUserId(loginUserId);
        this.classifyBarService.saveClassifyBar(classifyBar);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)INFO1, (String)(request.getSession().getAttribute(OPERAPATH) + INFO2 + customerName));
        String view = null == classifyBar.getChannelId() ? JUMPFORCLASSIFYBARVIEW1 + classifyBar.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken") : JUMPFORCLASSIFYBARVIEW2 + classifyBar.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken");
        return new ModelAndView((View)new RedirectView(view));
    }

    @RequestMapping(value={"/createtempclassifybarsubclassi"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createTempclassifyBarSubclassi(HttpServletRequest request, @Valid ClassifyBar classifyBar, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        if (null == classifyBar.getParentId()) {
            classifyBar.setGrade(Integer.valueOf(1));
        } else {
            classifyBar.setGrade(Integer.valueOf(this.classifyBarService.getClassifyBarById(classifyBar.getParentId()).getGrade() + 1));
        }
        classifyBar.setCreateUserId(loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)INFO1, (String)(request.getSession().getAttribute(OPERAPATH) + INFO2 + customerName));
        return this.classifyBarService.saveClassifyBar(classifyBar);
    }

    @RequestMapping(value={"/createtempclassifybarajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createTempClassifyBarAjax(HttpServletRequest request, ClassifyBar classifyBar, BindingResult bindingResult, Long[] barCateIds, String[] barCateNames, Long[] barQuickIds, String[] barQuickNames, Long[] barCIds, String[] barCNames, Long[] barQIds, String[] barQNames, Long goodsCatId, String[] bartemps, String[] barQTemps) {
        int i;
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        classifyBar.setGrade(Integer.valueOf(1));
        ArrayList<ClassifyBarCate> barCates = new ArrayList<ClassifyBarCate>();
        ArrayList<ClassifyBarQuick> barQuicks = new ArrayList<ClassifyBarQuick>();
        if (goodsCatId == -1L) {
            for (i = 0; i < barCIds.length; ++i) {
                if ("".equals(barCNames[i]) || barCNames[i] == null) continue;
                ClassifyBarCate barCate = new ClassifyBarCate();
                barCate.setCateId(barCIds[i]);
                barCate.setCateName(barCNames[i]);
                barCate.setTemp2(bartemps[i]);
                barCates.add(barCate);
            }
            for (i = 0; i < barQIds.length; ++i) {
                if ("".equals(barQNames[i]) || barQNames[i] == null) continue;
                ClassifyBarQuick barQuick = new ClassifyBarQuick();
                barQuick.setCateId(barQIds[i]);
                barQuick.setCateName(barQNames[i]);
                barQuick.setTemp2(barQTemps[i]);
                barQuicks.add(barQuick);
            }
            classifyBar.setGoodsCatId(barCIds[0]);
        } else {
            for (i = 0; i < barCateIds.length; ++i) {
                if (barCateIds[i] <= -1L) continue;
                ClassifyBarCate barCate = new ClassifyBarCate();
                barCate.setCateId(barCateIds[i]);
                barCate.setCateName(barCateNames[i]);
                barCates.add(barCate);
            }
            if (barQuickIds != null) {
                for (i = 0; i < barQuickIds.length; ++i) {
                    if (barQuickIds[i] <= 0L) continue;
                    ClassifyBarQuick barQuick = new ClassifyBarQuick();
                    barQuick.setCateId(barQuickIds[i]);
                    barQuick.setCateName(barQuickNames[i]);
                    barQuicks.add(barQuick);
                }
            }
            classifyBar.setGoodsCatId(barCateIds[0]);
        }
        classifyBar.setCreateUserId(loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)INFO1, (String)(request.getSession().getAttribute(OPERAPATH) + INFO2 + customerName));
        return this.classifyBarService.saveClassifyBarAndCateAndQuick(classifyBar, barCates, barQuicks);
    }

    @RequestMapping(value={"/createTempClassifyBarAndCateAndQuick"})
    public ModelAndView createTempClassifyBarAndCateAndQuick(MultipartHttpServletRequest request, @Valid ClassifyBar classifyBar, BindingResult bindingResult, Long[] barCateIds, String[] barCateNames, Long[] barQuickIds, String[] barQuickNames, Long[] barCIds, String[] barCNames, Long[] barQIds, String[] barQNames, Long goodsCatId, String[] bartemps, String[] barQTemps) {
        ClassifyBarQuick barQuick;
        ClassifyBarCate barCate;
        int i;
        if (bindingResult.hasErrors()) {
            if (null == classifyBar.getChannelId()) {
                return new ModelAndView((View)new RedirectView(JUMPFORCLASSIFYBARVIEW1 + classifyBar.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
            }
            return new ModelAndView((View)new RedirectView(JUMPFORCLASSIFYBARVIEW2 + classifyBar.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        classifyBar.setGrade(Integer.valueOf(1));
        MultipartFile muFile = request.getFile(IMGSRC);
        if (null != muFile && muFile.getSize() > 0L) {
            classifyBar.setTemp2(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
        }
        ArrayList<ClassifyBarCate> barCates = new ArrayList<ClassifyBarCate>();
        ArrayList<ClassifyBarQuick> barQuicks = new ArrayList<ClassifyBarQuick>();
        if (goodsCatId == -1L) {
            for (i = 0; i < barCIds.length; ++i) {
                if ("".equals(barCNames[i]) || barCNames[i] == null) continue;
                barCate = new ClassifyBarCate();
                barCate.setCateId(barCIds[i]);
                barCate.setCateName(barCNames[i]);
                barCate.setTemp2(bartemps[i]);
                barCates.add(barCate);
            }
            for (i = 0; i < barQIds.length; ++i) {
                if ("".equals(barQNames[i]) || barQNames[i] == null) continue;
                barQuick = new ClassifyBarQuick();
                barQuick.setCateId(barQIds[i]);
                barQuick.setCateName(barQNames[i]);
                barQuick.setTemp2(barQTemps[i]);
                barQuicks.add(barQuick);
            }
            classifyBar.setGoodsCatId(barCIds[0]);
        } else {
            for (i = 0; i < barCateIds.length; ++i) {
                if (barCateIds[i] <= -1L) continue;
                barCate = new ClassifyBarCate();
                barCate.setCateId(barCateIds[i]);
                barCate.setCateName(barCateNames[i]);
                barCates.add(barCate);
            }
            for (i = 0; i < barQuickIds.length; ++i) {
                if (barQuickIds[i] <= 0L) continue;
                barQuick = new ClassifyBarQuick();
                barQuick.setCateId(barQuickIds[i]);
                barQuick.setCateName(barQuickNames[i]);
                barQuicks.add(barQuick);
            }
            classifyBar.setGoodsCatId(barCateIds[0]);
        }
        classifyBar.setCreateUserId(loginUserId);
        this.classifyBarService.saveClassifyBarAndCateAndQuick(classifyBar, barCates, barQuicks);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)INFO1, (String)(request.getSession().getAttribute(OPERAPATH) + INFO2 + customerName));
        String view = null == classifyBar.getChannelId() ? JUMPFORCLASSIFYBARVIEW1 + classifyBar.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken") : JUMPFORCLASSIFYBARVIEW2 + classifyBar.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken");
        return new ModelAndView((View)new RedirectView(view));
    }

    @RequestMapping(value={"/updateTempClassifyBar"})
    public ModelAndView updateTempClassifyBar(MultipartHttpServletRequest request, @Valid ClassifyBar classifyBar, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            if (null == classifyBar.getChannelId()) {
                return new ModelAndView((View)new RedirectView(JUMPFORCLASSIFYBARVIEW1 + classifyBar.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
            }
            return new ModelAndView((View)new RedirectView(JUMPFORCLASSIFYBARVIEW2 + classifyBar.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        if (null == classifyBar.getParentId()) {
            classifyBar.setGrade(Integer.valueOf(1));
        } else {
            classifyBar.setGrade(Integer.valueOf(this.classifyBarService.getClassifyBarById(classifyBar.getParentId()).getGrade() + 1));
        }
        MultipartFile muFile = request.getFile(IMGSRC);
        if (null != muFile && muFile.getSize() > 0L) {
            classifyBar.setTemp2(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
        }
        classifyBar.setUpdateUserId(loginUserId);
        this.classifyBarService.updateClassifyBar(classifyBar);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)INFO3, (String)(request.getSession().getAttribute(OPERAPATH) + INFO2 + customerName));
        String view = null == classifyBar.getChannelId() ? JUMPFORCLASSIFYBARVIEW1 + classifyBar.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken") : JUMPFORCLASSIFYBARVIEW2 + classifyBar.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken");
        return new ModelAndView((View)new RedirectView(view));
    }

    @RequestMapping(value={"/updatetempclassifybarajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ClassifyBar updateTempClassifyBarAjax(HttpServletRequest request, @Valid ClassifyBar classifyBar, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return null;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        if (null == classifyBar.getParentId()) {
            classifyBar.setGrade(Integer.valueOf(1));
        } else {
            classifyBar.setGrade(Integer.valueOf(this.classifyBarService.getClassifyBarById(classifyBar.getParentId()).getGrade() + 1));
        }
        classifyBar.setUpdateUserId(loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)INFO3, (String)(request.getSession().getAttribute(OPERAPATH) + INFO2 + customerName));
        int a = this.classifyBarService.updateClassifyBar(classifyBar);
        if (a == 1) {
            return classifyBar;
        }
        return null;
    }

    @RequestMapping(value={"/updateTempClassifyBarAndCateAndQuick"})
    public ModelAndView updateTempClassifyBarAndCateAndQuick(MultipartHttpServletRequest request, @Valid ClassifyBar classifyBar, BindingResult bindingResult, Long[] barCateIds, String[] barCateNames, Long[] barQuickIds, String[] barQuickNames, Long[] barCIds, String[] barCNames, Long[] barQIds, String[] barQNames, Long goodsCatId, String[] bartemps, String[] barQTemps) {
        ClassifyBarQuick barQuick;
        ClassifyBarCate barCate;
        int i;
        MultipartFile muFile;
        if (bindingResult.hasErrors()) {
            if (null == classifyBar.getChannelId()) {
                return new ModelAndView((View)new RedirectView(JUMPFORCLASSIFYBARVIEW1 + classifyBar.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
            }
            return new ModelAndView((View)new RedirectView(JUMPFORCLASSIFYBARVIEW2 + classifyBar.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        if (null != (muFile = request.getFile(IMGSRC)) && muFile.getSize() > 0L) {
            classifyBar.setTemp2(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
        }
        ArrayList<ClassifyBarCate> barCates = new ArrayList<ClassifyBarCate>();
        ArrayList<ClassifyBarQuick> barQuicks = new ArrayList<ClassifyBarQuick>();
        if (goodsCatId == -1L) {
            for (i = 0; i < barCIds.length; ++i) {
                if ("".equals(barCNames[i]) || barCNames[i] == null) continue;
                barCate = new ClassifyBarCate();
                barCate.setCateId(barCIds[i]);
                barCate.setCateName(barCNames[i]);
                barCate.setTemp2(bartemps[i]);
                barCates.add(barCate);
            }
            for (i = 0; i < barQIds.length; ++i) {
                if (barQNames[i] == null || "".equals(barQNames[i])) continue;
                barQuick = new ClassifyBarQuick();
                barQuick.setCateId(barQIds[i]);
                barQuick.setCateName(barQNames[i]);
                barQuick.setTemp2(barQTemps[i]);
                barQuicks.add(barQuick);
            }
            classifyBar.setGoodsCatId(barCIds[0]);
        } else {
            for (i = 0; i < barCateIds.length; ++i) {
                if (barCateIds[i] <= -1L) continue;
                barCate = new ClassifyBarCate();
                barCate.setCateId(barCateIds[i]);
                barCate.setCateName(barCateNames[i]);
                barCates.add(barCate);
            }
            for (i = 0; i < barQuickIds.length; ++i) {
                if (barQuickIds[i] <= 0L) continue;
                barQuick = new ClassifyBarQuick();
                barQuick.setCateId(barQuickIds[i]);
                barQuick.setCateName(barQuickNames[i]);
                barQuicks.add(barQuick);
            }
            classifyBar.setGoodsCatId(barCateIds[0]);
        }
        classifyBar.setUpdateUserId(loginUserId);
        this.classifyBarService.updateClassifyBarAndCateAndQuick(classifyBar, barCates, barQuicks);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)INFO3, (String)(request.getSession().getAttribute(OPERAPATH) + INFO2 + customerName));
        String view = null == classifyBar.getChannelId() ? JUMPFORCLASSIFYBARVIEW1 + classifyBar.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken") : JUMPFORCLASSIFYBARVIEW2 + classifyBar.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken");
        return new ModelAndView((View)new RedirectView(view));
    }

    @RequestMapping(value={"/updatetempclassifybarandcateandquickajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateTempClassifyBarAndCateAndQuickAjax(HttpServletRequest request, @Valid ClassifyBar classifyBar, BindingResult bindingResult, Long[] barCateIds, String[] barCateNames, Long[] barQuickIds, String[] barQuickNames, Long[] barCIds, String[] barCNames, Long[] barQIds, String[] barQNames, Long goodsCatId, String[] bartemps, String[] barQTemps) {
        int i;
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        ArrayList<ClassifyBarCate> barCates = new ArrayList<ClassifyBarCate>();
        ArrayList<ClassifyBarQuick> barQuicks = new ArrayList<ClassifyBarQuick>();
        if (goodsCatId == -1L) {
            for (i = 0; i < barCIds.length; ++i) {
                if ("".equals(barCNames[i]) || barCNames[i] == null) continue;
                ClassifyBarCate barCate = new ClassifyBarCate();
                barCate.setCateId(barCIds[i]);
                barCate.setCateName(barCNames[i]);
                barCate.setTemp2(bartemps[i]);
                barCates.add(barCate);
            }
            for (i = 0; i < barQIds.length; ++i) {
                if (barQNames[i] == null || "".equals(barQNames[i])) continue;
                ClassifyBarQuick barQuick = new ClassifyBarQuick();
                barQuick.setCateId(barQIds[i]);
                barQuick.setCateName(barQNames[i]);
                barQuick.setTemp2(barQTemps[i]);
                barQuicks.add(barQuick);
            }
            classifyBar.setGoodsCatId(barCIds[0]);
        } else {
            for (i = 0; i < barCateIds.length; ++i) {
                if (barCateIds[i] <= -1L) continue;
                ClassifyBarCate barCate = new ClassifyBarCate();
                barCate.setCateId(barCateIds[i]);
                barCate.setCateName(barCateNames[i]);
                barCates.add(barCate);
            }
            for (i = 0; i < barQuickIds.length; ++i) {
                if (barQuickIds[i] <= 0L) continue;
                ClassifyBarQuick barQuick = new ClassifyBarQuick();
                barQuick.setCateId(barQuickIds[i]);
                barQuick.setCateName(barQuickNames[i]);
                barQuicks.add(barQuick);
            }
            classifyBar.setGoodsCatId(barCateIds[0]);
        }
        classifyBar.setUpdateUserId(loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)INFO3, (String)(request.getSession().getAttribute(OPERAPATH) + INFO2 + customerName));
        return this.classifyBarService.updateClassifyBarAndCateAndQuick(classifyBar, barCates, barQuicks);
    }

    @ResponseBody
    @RequestMapping(value={"/deleteTempClassifyBar"}, produces={"application/json;charset=UTF-8"})
    public void deleteTempClassifyBar(Long classifyBarId, HttpServletRequest request, HttpServletResponse response) {
        this.classifyBarService.deleteClassifyBar(classifyBarId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u5206\u7c7b\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + INFO2 + customerName));
    }

    @ResponseBody
    @RequestMapping(value={"/deleteClassifyBarAndCateAndQuick"}, produces={"application/json;charset=UTF-8"})
    public void deleteClassifyBarAndCateAndQuick(Long classifyBarId, HttpServletRequest request) {
        try {
            this.classifyBarService.deleteByPrimaryKeyAndPro(classifyBarId);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u5206\u7c7b\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + INFO2 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public TempService getTempService() {
        return this.tempService;
    }

    @Resource(name="TempService")
    public void setTempService(TempService tempService) {
        this.tempService = tempService;
    }

    public ClassifyBarService getClassifyBarService() {
        return this.classifyBarService;
    }

    @Resource(name="ClassifyBarService")
    public void setClassifyBarService(ClassifyBarService classifyBarService) {
        this.classifyBarService = classifyBarService;
    }

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="ChannelGoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }
}

